"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toPosixPath = void 0;
const path = require("path");
/**
 * Convert a file path on the current system to a file path that can be used on Linux
 *
 * Takes the current OS' file separator and replaces all of them with a '/'.
 *
 * Relevant if the current system is a Windows machine but is generating
 * commands for a Linux CodeBuild image.
 */
function toPosixPath(osPath, currentSep) {
    const regex = new RegExp(`\\${currentSep !== null && currentSep !== void 0 ? currentSep : path.sep}`, 'g');
    return osPath.replace(regex, '/');
}
exports.toPosixPath = toPosixPath;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2QkFBNkI7QUFDN0I7Ozs7Ozs7R0FPRztBQUNILFNBQWdCLFdBQVcsQ0FBQyxNQUFjLEVBQUUsVUFBbUI7SUFDM0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxNQUFNLENBQUMsS0FBSyxVQUFVLGFBQVYsVUFBVSxjQUFWLFVBQVUsR0FBSSxJQUFJLENBQUMsR0FBRyxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDN0QsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsQ0FBQztBQUN0QyxDQUFDO0FBSEQsa0NBR0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuLyoqXG4gKiBDb252ZXJ0IGEgZmlsZSBwYXRoIG9uIHRoZSBjdXJyZW50IHN5c3RlbSB0byBhIGZpbGUgcGF0aCB0aGF0IGNhbiBiZSB1c2VkIG9uIExpbnV4XG4gKlxuICogVGFrZXMgdGhlIGN1cnJlbnQgT1MnIGZpbGUgc2VwYXJhdG9yIGFuZCByZXBsYWNlcyBhbGwgb2YgdGhlbSB3aXRoIGEgJy8nLlxuICpcbiAqIFJlbGV2YW50IGlmIHRoZSBjdXJyZW50IHN5c3RlbSBpcyBhIFdpbmRvd3MgbWFjaGluZSBidXQgaXMgZ2VuZXJhdGluZ1xuICogY29tbWFuZHMgZm9yIGEgTGludXggQ29kZUJ1aWxkIGltYWdlLlxuICovXG5leHBvcnQgZnVuY3Rpb24gdG9Qb3NpeFBhdGgob3NQYXRoOiBzdHJpbmcsIGN1cnJlbnRTZXA/OiBzdHJpbmcpIHtcbiAgICBjb25zdCByZWdleCA9IG5ldyBSZWdFeHAoYFxcXFwke2N1cnJlbnRTZXAgPz8gcGF0aC5zZXB9YCwgJ2cnKTtcbiAgICByZXR1cm4gb3NQYXRoLnJlcGxhY2UocmVnZXgsICcvJyk7XG59XG4iXX0=