"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdatePipelineAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../aws-codebuild"); // Automatically re-written from '@aws-cdk/aws-codebuild'
const cpactions = require("../../../aws-codepipeline-actions"); // Automatically re-written from '@aws-cdk/aws-codepipeline-actions'
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const construct_internals_1 = require("../private/construct-internals");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Action to self-mutate the pipeline.
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to deploy the pipeline stack.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline.
 *
 * @experimental
 */
class UpdatePipelineAction extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : '';
        const stackIdentifier = (_b = props.pipelineStackHierarchicalId) !== null && _b !== void 0 ? _b : props.pipelineStackName;
        const selfMutationProject = new codebuild.PipelineProject(this, 'SelfMutation', {
            projectName: props.projectName,
            environment: {
                buildImage: codebuild.LinuxBuildImage.STANDARD_5_0,
                privileged: (_c = props.privileged) !== null && _c !== void 0 ? _c : false,
            },
            buildSpec: codebuild.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    install: {
                        commands: `npm install -g aws-cdk${installSuffix}`,
                    },
                    build: {
                        commands: [
                            // Cloud Assembly is in *current* directory.
                            `cdk -a ${construct_internals_1.embeddedAsmPath(scope)} deploy ${stackIdentifier} --require-approval=never --verbose`,
                        ],
                    },
                },
            }),
        });
        // allow the self-mutating project permissions to assume the bootstrap Action role
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['sts:AssumeRole'],
            resources: ['arn:*:iam::*:role/*-deploy-role-*', 'arn:*:iam::*:role/*-publishing-role-*'],
        }));
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['cloudformation:DescribeStacks'],
            resources: ['*'],
        }));
        // S3 checks for the presence of the ListBucket permission
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:ListBucket'],
            resources: ['*'],
        }));
        this.action = new cpactions.CodeBuildAction({
            actionName: 'SelfMutate',
            input: props.cloudAssemblyInput,
            project: selfMutationProject,
            // Add this purely so that the pipeline will selfupdate if the CLI version changes
            environmentVariables: props.cdkCliVersion ? {
                CDK_CLI_VERSION: { value: props.cdkCliVersion },
            } : undefined,
        });
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope, stage, options) {
        return this.action.bind(scope, stage, options);
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name, target, options) {
        return this.action.onStateChange(name, target, options);
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties() {
        // FIXME: I have had to make this class a Construct, because:
        //
        // - It needs access to the Construct tree, because it is going to add a `PipelineProject`.
        // - I would have liked to have done that in bind(), however,
        // - `actionProperties` (this method) is called BEFORE bind() is called, and by that point I
        //   don't have the "inner" Action yet to forward the call to.
        //
        // I've therefore had to construct the inner CodeBuildAction in the constructor, which requires making this
        // Action a Construct.
        //
        // Combined with how non-intuitive it is to make the "StackDeployAction", I feel there is something
        // wrong with the Action abstraction here.
        return this.action.actionProperties;
    }
}
exports.UpdatePipelineAction = UpdatePipelineAction;
_a = JSII_RTTI_SYMBOL_1;
UpdatePipelineAction[_a] = { fqn: "monocdk.pipelines.UpdatePipelineAction", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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