"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeployCdkStackAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cpactions = require("../../../aws-codepipeline-actions"); // Automatically re-written from '@aws-cdk/aws-codepipeline-actions'
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const cxapi = require("../../../cx-api"); // Automatically re-written from '@aws-cdk/cx-api'
const constructs_1 = require("constructs");
const construct_internals_1 = require("../private/construct-internals");
const fs_1 = require("../private/fs");
/**
 * (experimental) Action to deploy a CDK Stack.
 *
 * Adds two CodePipeline Actions to the pipeline: one to create a ChangeSet
 * and one to execute it.
 *
 * You do not need to instantiate this action yourself -- it will automatically
 * be added by the pipeline when you add stack artifacts or entire stages.
 *
 * @experimental
 */
class DeployCdkStackAction {
    /**
     * @experimental
     */
    constructor(props) {
        var _b, _c, _d, _e, _f;
        if (props.output && !props.outputFileName) {
            throw new Error('If \'output\' is set, \'outputFileName\' is also required');
        }
        this.stackArtifactId = props.stackArtifactId;
        this.dependencyStackArtifactIds = (_b = props.dependencyStackArtifactIds) !== null && _b !== void 0 ? _b : [];
        this.prepareRunOrder = (_c = props.prepareRunOrder) !== null && _c !== void 0 ? _c : 1;
        this.executeRunOrder = (_d = props.executeRunOrder) !== null && _d !== void 0 ? _d : this.prepareRunOrder + 1;
        this.stackName = props.stackName;
        const baseActionName = (_e = props.baseActionName) !== null && _e !== void 0 ? _e : this.stackName;
        const changeSetName = (_f = props.changeSetName) !== null && _f !== void 0 ? _f : 'PipelineChange';
        this.prepareChangeSetAction = new cpactions.CloudFormationCreateReplaceChangeSetAction({
            actionName: `${baseActionName}.Prepare`,
            changeSetName,
            runOrder: this.prepareRunOrder,
            stackName: this.stackName,
            templatePath: props.cloudAssemblyInput.atPath(props.templatePath),
            adminPermissions: false,
            role: props.actionRole,
            deploymentRole: props.cloudFormationExecutionRole,
            region: props.region,
            cfnCapabilities: [core_1.CfnCapabilities.NAMED_IAM, core_1.CfnCapabilities.AUTO_EXPAND],
            templateConfiguration: props.templateConfigurationPath ? props.cloudAssemblyInput.atPath(props.templateConfigurationPath) : undefined,
        });
        this.executeChangeSetAction = new cpactions.CloudFormationExecuteChangeSetAction({
            actionName: `${baseActionName}.Deploy`,
            changeSetName,
            runOrder: this.executeRunOrder,
            stackName: this.stackName,
            role: props.actionRole,
            region: props.region,
            outputFileName: props.outputFileName,
            output: props.output,
        });
    }
    /**
     * (experimental) Construct a DeployCdkStackAction from a Stack artifact.
     *
     * @experimental
     */
    static fromStackArtifact(scope, artifact, options) {
        var _b;
        if (!artifact.assumeRoleArn) {
            throw new Error(`Stack '${artifact.stackName}' does not have deployment role information; use the 'DefaultStackSynthesizer' synthesizer, or set the '@aws-cdk/core:newStyleStackSynthesis' context key.`);
        }
        const artRegion = artifact.environment.region;
        const region = artRegion === core_1.Stack.of(scope).region || artRegion === cxapi.UNKNOWN_REGION ? undefined : artRegion;
        const artAccount = artifact.environment.account;
        const account = artAccount === core_1.Stack.of(scope).account || artAccount === cxapi.UNKNOWN_ACCOUNT ? undefined : artAccount;
        const actionRole = roleFromPlaceholderArn(scope, region, account, artifact.assumeRoleArn);
        const cloudFormationExecutionRole = roleFromPlaceholderArn(scope, region, account, artifact.cloudFormationExecutionRoleArn);
        // We need the path of the template relative to the root Cloud Assembly
        // It should be easier to get this, but for now it is what it is.
        const appAsmRoot = construct_internals_1.assemblyBuilderOf(construct_internals_1.appOf(scope)).outdir;
        const fullTemplatePath = path.join(artifact.assembly.directory, artifact.templateFile);
        let fullConfigPath;
        if (Object.keys(artifact.tags).length > 0) {
            fullConfigPath = `${fullTemplatePath}.config.json`;
            // Write the template configuration file (for parameters into CreateChangeSet call that
            // cannot be configured any other way). They must come from a file, and there's unfortunately
            // no better hook to write this file (`construct.onSynthesize()` would have been the prime candidate
            // but that is being deprecated--and DeployCdkStackAction isn't even a construct).
            writeTemplateConfiguration(fullConfigPath, {
                Tags: artifact.tags,
            });
        }
        return new DeployCdkStackAction({
            actionRole,
            cloudFormationExecutionRole,
            templatePath: fs_1.toPosixPath(path.relative(appAsmRoot, fullTemplatePath)),
            templateConfigurationPath: fullConfigPath ? fs_1.toPosixPath(path.relative(appAsmRoot, fullConfigPath)) : undefined,
            region,
            stackArtifactId: artifact.id,
            dependencyStackArtifactIds: artifact.dependencies.filter(isStackArtifact).map(s => s.id),
            stackName: (_b = options.stackName) !== null && _b !== void 0 ? _b : artifact.stackName,
            ...options,
        });
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope, stage, options) {
        stage.addAction(this.prepareChangeSetAction);
        return this.executeChangeSetAction.bind(scope, stage, options);
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name, target, options) {
        return this.executeChangeSetAction.onStateChange(name, target, options);
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties() {
        return this.executeChangeSetAction.actionProperties;
    }
}
exports.DeployCdkStackAction = DeployCdkStackAction;
_a = JSII_RTTI_SYMBOL_1;
DeployCdkStackAction[_a] = { fqn: "monocdk.pipelines.DeployCdkStackAction", version: "1.106.1" };
function roleFromPlaceholderArn(scope, region, account, arn) {
    if (!arn) {
        return undefined;
    }
    // Use placeholdered arn as construct ID.
    const id = arn;
    // https://github.com/aws/aws-cdk/issues/7255
    let existingRole = constructs_1.Node.of(scope).tryFindChild(`ImmutableRole${id}`);
    if (existingRole) {
        return existingRole;
    }
    // For when #7255 is fixed.
    existingRole = constructs_1.Node.of(scope).tryFindChild(id);
    if (existingRole) {
        return existingRole;
    }
    const arnToImport = cxapi.EnvironmentPlaceholders.replace(arn, {
        region: region !== null && region !== void 0 ? region : core_1.Aws.REGION,
        accountId: account !== null && account !== void 0 ? account : core_1.Aws.ACCOUNT_ID,
        partition: core_1.Aws.PARTITION,
    });
    return iam.Role.fromRoleArn(scope, id, arnToImport, { mutable: false });
}
function isStackArtifact(a) {
    // instanceof is too risky, and we're at a too late stage to properly fix.
    // return a instanceof cxapi.CloudFormationStackArtifact;
    return a.constructor.name === 'CloudFormationStackArtifact';
}
/**
 * Write template configuration to the given file
 */
function writeTemplateConfiguration(filename, config) {
    fs.writeFileSync(filename, JSON.stringify(config, undefined, 2), { encoding: 'utf-8' });
}
//# sourceMappingURL=data:application/json;base64,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