"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubectlLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
/**
 * (experimental) An AWS Lambda layer that includes `kubectl` and `helm`.
 *
 * @experimental
 */
class KubectlLayer extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope, id) {
        super(scope, id, {
            code: lambda.Code.fromAsset(path.join(__dirname, 'layer.zip'), {
                // we hash the Dockerfile (it contains the tools versions) because hashing the zip is non-deterministic
                assetHash: hashFile(path.join(__dirname, '..', 'layer', 'Dockerfile')),
            }),
            description: '/opt/kubectl/kubectl and /opt/helm/helm',
        });
    }
}
exports.KubectlLayer = KubectlLayer;
_a = JSII_RTTI_SYMBOL_1;
KubectlLayer[_a] = { fqn: "monocdk.lambda_layer_kubectl.KubectlLayer", version: "1.106.1" };
function hashFile(fileName) {
    return crypto
        .createHash('sha256')
        .update(fs.readFileSync(fileName))
        .digest('hex');
}
//# sourceMappingURL=data:application/json;base64,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