"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.futureFlagDefault = exports.FUTURE_FLAGS_EXPIRED = exports.FUTURE_FLAGS = exports.LAMBDA_RECOGNIZE_VERSION_PROPS = exports.EFS_DEFAULT_ENCRYPTION_AT_REST = exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = exports.RDS_LOWERCASE_DB_IDENTIFIER = exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = exports.S3_GRANT_WRITE_WITHOUT_ACL = exports.KMS_DEFAULT_KEY_POLICIES = exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = exports.DOCKER_IGNORE_SUPPORT = exports.STACK_RELATIVE_EXPORTS_CONTEXT = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file. In the next major release of the CDK, these feature flags
// will be removed and will become the default behavior.
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
/**
 * If this is set, multiple stacks can use the same stack name (e.g. deployed to
 * different environments). This means that the name of the synthesized template
 * file will be based on the construct path and not on the defined `stackName`
 * of the stack.
 *
 * This is a "future flag": the feature is disabled by default for backwards
 * compatibility, but new projects created using `cdk init` will have this
 * enabled through the generated `cdk.json`.
 */
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
/**
 * IF this is set, `cdk diff` will always exit with 0.
 *
 * Use `cdk diff --fail` to exit with 1 if there's a diff.
 */
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
/**
 * Switch to new stack synthesis method which enable CI/CD
 */
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
/**
 * Name exports based on the construct paths relative to the stack, rather than the global construct path
 *
 * Combined with the stack name this relative construct path is good enough to
 * ensure uniqueness, and makes the export names robust against refactoring
 * the location of the stack in the construct tree (specifically, moving the Stack
 * into a Stage).
 */
exports.STACK_RELATIVE_EXPORTS_CONTEXT = '@aws-cdk/core:stackRelativeExports';
/**
 * DockerImageAsset properly supports `.dockerignore` files by default
 *
 * If this flag is not set, the default behavior for `DockerImageAsset` is to use
 * glob semantics for `.dockerignore` files. If this flag is set, the default behavior
 * is standard Docker ignore semantics.
 *
 * This is a feature flag as the old behavior was technically incorrect but
 * users may have come to depend on it.
 */
exports.DOCKER_IGNORE_SUPPORT = '@aws-cdk/aws-ecr-assets:dockerIgnoreSupport';
/**
 * Secret.secretName for an "owned" secret will attempt to parse the secretName from the ARN,
 * rather than the default full resource name, which includes the SecretsManager suffix.
 *
 * If this flag is not set, Secret.secretName will include the SecretsManager suffix, which cannot be directly
 * used by SecretsManager.DescribeSecret, and must be parsed by the user first (e.g., Fn:Join, Fn:Select, Fn:Split).
 */
exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = '@aws-cdk/aws-secretsmanager:parseOwnedSecretName';
/**
 * KMS Keys start with a default key policy that grants the account access to administer the key,
 * mirroring the behavior of the KMS SDK/CLI/Console experience. Users may override the default key
 * policy by specifying their own.
 *
 * If this flag is not set, the default key policy depends on the setting of the `trustAccountIdentities`
 * flag. If false (the default, for backwards-compatibility reasons), the default key policy somewhat
 * resemebles the default admin key policy, but with the addition of 'GenerateDataKey' permissions. If
 * true, the policy matches what happens when this feature flag is set.
 *
 * Additionally, if this flag is not set and the user supplies a custom key policy, this will be appended
 * to the key's default policy (rather than replacing it).
 */
exports.KMS_DEFAULT_KEY_POLICIES = '@aws-cdk/aws-kms:defaultKeyPolicies';
/**
 * Change the old 's3:PutObject*' permission to 's3:PutObject' on Bucket,
 * as the former includes 's3:PutObjectAcl',
 * which could be used to grant read/write object access to IAM principals in other accounts.
 * Use a feature flag to make sure existing customers who might be relying
 * on the overly-broad permissions are not broken.
 */
exports.S3_GRANT_WRITE_WITHOUT_ACL = '@aws-cdk/aws-s3:grantWriteWithoutAcl';
/**
 * ApplicationLoadBalancedServiceBase, ApplicationMultipleTargetGroupServiceBase,
 * NetworkLoadBalancedServiceBase, NetworkMultipleTargetGroupServiceBase, and
 * QueueProcessingServiceBase currently determine a default value for the desired count of
 * a CfnService if a desiredCount is not provided.
 *
 * If this flag is not set, the default behaviour for CfnService.desiredCount is to set a
 * desiredCount of 1, if one is not provided. If true, a default will not be defined for
 * CfnService.desiredCount and as such desiredCount will be undefined, if one is not provided.
 *
 * This is a feature flag as the old behavior was technically incorrect, but
 * users may have come to depend on it.
 */
exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = '@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount';
/**
 * ServerlessCluster.clusterIdentifier currently can has uppercase letters,
 * and ServerlessCluster pass it through to CfnDBCluster.dbClusterIdentifier.
 * The identifier is saved as lowercase string in AWS and is resolved as original string in CloudFormation.
 *
 * If this flag is not set, original value that one set to ServerlessCluster.clusterIdentifier
 * is passed to CfnDBCluster.dbClusterIdentifier.
 * If this flag is true, ServerlessCluster.clusterIdentifier is converted into a string containing
 * only lowercase characters by the `toLowerCase` function and passed to CfnDBCluster.dbClusterIdentifier.
 *
 * This feature flag make correct the ServerlessCluster.clusterArn when
 * clusterIdentifier contains a Upper case letters.
 */
exports.RDS_LOWERCASE_DB_IDENTIFIER = '@aws-cdk/aws-rds:lowercaseDbIdentifier';
/**
 * The UsagePlanKey resource connects an ApiKey with a UsagePlan. API Gateway does not allow more than one UsagePlanKey
 * for any given UsagePlan and ApiKey combination. For this reason, CloudFormation cannot replace this resource without
 * either the UsagePlan or ApiKey changing.
 *
 * The feature addition to support multiple UsagePlanKey resources - 142bd0e2 - recognized this and attempted to keep
 * existing UsagePlanKey logical ids unchanged.
 * However, this intentionally caused the logical id of the UsagePlanKey to be sensitive to order. That is, when
 * the 'first' UsagePlanKey resource is removed, the logical id of the 'second' assumes what was originally the 'first',
 * which again is disallowed.
 *
 * In effect, there is no way to get out of this mess in a backwards compatible way, while supporting existing stacks.
 * This flag changes the logical id layout of UsagePlanKey to not be sensitive to order.
 */
exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = '@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId';
/**
 * Enable this feature flag to have elastic file systems encrypted at rest by default.
 *
 * Encryption can also be configured explicitly using the `encrypted` property.
 */
exports.EFS_DEFAULT_ENCRYPTION_AT_REST = '@aws-cdk/aws-efs:defaultEncryptionAtRest';
/**
 * Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the
 * `fn.currentVersion`.
 *
 * The previous calculation incorrectly considered properties of the `AWS::Lambda::Function` resource that did
 * not constitute creating a new Version.
 *
 * See 'currentVersion' section in the aws-lambda module's README for more details.
 */
exports.LAMBDA_RECOGNIZE_VERSION_PROPS = '@aws-cdk/aws-lambda:recognizeVersionProps';
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdk init` will include these flags in their
 * generated `cdk.json` file.
 *
 * When we release the next major version of the CDK, we will flip the logic of
 * these features and clean up the `cdk.json` generated by `cdk init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {
    [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: true,
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: 'true',
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: 'true',
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: 'true',
    [exports.DOCKER_IGNORE_SUPPORT]: true,
    [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: true,
    [exports.KMS_DEFAULT_KEY_POLICIES]: true,
    [exports.S3_GRANT_WRITE_WITHOUT_ACL]: true,
    [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: true,
    [exports.RDS_LOWERCASE_DB_IDENTIFIER]: true,
    [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: true,
    [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: true,
};
/**
 * The list of future flags that are now expired. This is going to be used to identify
 * and block usages of old feature flags in the new major version of CDK.
 */
exports.FUTURE_FLAGS_EXPIRED = [];
/**
 * The set of defaults that should be applied if the feature flag is not
 * explicitly configured.
 */
const FUTURE_FLAGS_DEFAULTS = {
    [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: false,
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: false,
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: false,
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: false,
    [exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: false,
    [exports.DOCKER_IGNORE_SUPPORT]: false,
    [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: false,
    [exports.KMS_DEFAULT_KEY_POLICIES]: false,
    [exports.S3_GRANT_WRITE_WITHOUT_ACL]: false,
    [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: false,
    [exports.RDS_LOWERCASE_DB_IDENTIFIER]: false,
    [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: false,
    [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: false,
};
function futureFlagDefault(flag) {
    return FUTURE_FLAGS_DEFAULTS[flag];
}
exports.futureFlagDefault = futureFlagDefault;
//# sourceMappingURL=data:application/json;base64,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