"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentUtils = exports.UNKNOWN_REGION = exports.UNKNOWN_ACCOUNT = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Parser for the artifact environment field.
 *
 * Account validation is relaxed to allow account aliasing in the future.
 */
const AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
exports.UNKNOWN_ACCOUNT = 'unknown-account';
exports.UNKNOWN_REGION = 'unknown-region';
/**
 * @experimental
 */
class EnvironmentUtils {
    /**
     * @experimental
     */
    static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env) {
            throw new Error(`Unable to parse environment specification "${environment}". ` +
                'Expected format: aws://account/region');
        }
        const [, account, region] = env;
        if (!account || !region) {
            throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
    }
    /**
     * (experimental) Build an environment object from an account and region.
     *
     * @experimental
     */
    static make(account, region) {
        return { account, region, name: this.format(account, region) };
    }
    /**
     * (experimental) Format an environment string from an account and region.
     *
     * @experimental
     */
    static format(account, region) {
        return `aws://${account}/${region}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentUtils[_a] = { fqn: "monocdk.cx_api.EnvironmentUtils", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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