import * as cxschema from "../../cloud-assembly-schema";
import { CloudFormationStackArtifact } from './artifacts/cloudformation-artifact';
import { NestedCloudAssemblyArtifact } from './artifacts/nested-cloud-assembly-artifact';
import { TreeCloudArtifact } from './artifacts/tree-cloud-artifact';
import { CloudArtifact } from './cloud-artifact';
/**
 * (experimental) Represents a deployable cloud application.
 *
 * @experimental
 */
export declare class CloudAssembly {
    /**
     * (experimental) The root directory of the cloud assembly.
     *
     * @experimental
     */
    readonly directory: string;
    /**
     * (experimental) The schema version of the assembly manifest.
     *
     * @experimental
     */
    readonly version: string;
    /**
     * (experimental) All artifacts included in this assembly.
     *
     * @experimental
     */
    readonly artifacts: CloudArtifact[];
    /**
     * (experimental) Runtime information such as module versions used to synthesize this assembly.
     *
     * @experimental
     */
    readonly runtime: cxschema.RuntimeInfo;
    /**
     * (experimental) The raw assembly manifest.
     *
     * @experimental
     */
    readonly manifest: cxschema.AssemblyManifest;
    /**
     * (experimental) Reads a cloud assembly from the specified directory.
     *
     * @param directory The root directory of the assembly.
     * @experimental
     */
    constructor(directory: string);
    /**
     * (experimental) Attempts to find an artifact with a specific identity.
     *
     * @param id The artifact ID.
     * @returns A `CloudArtifact` object or `undefined` if the artifact does not exist in this assembly.
     * @experimental
     */
    tryGetArtifact(id: string): CloudArtifact | undefined;
    /**
     * (experimental) Returns a CloudFormation stack artifact from this assembly.
     *
     * Will only search the current assembly.
     *
     * @param stackName the name of the CloudFormation stack.
     * @returns a `CloudFormationStackArtifact` object.
     * @experimental
     * @throws if there is more than one stack with the same stack name. You can
     * use `getStackArtifact(stack.artifactId)` instead.
     */
    getStackByName(stackName: string): CloudFormationStackArtifact;
    /**
     * (deprecated) Returns a CloudFormation stack artifact by name from this assembly.
     *
     * @deprecated renamed to `getStackByName` (or `getStackArtifact(id)`)
     */
    getStack(stackName: string): CloudFormationStackArtifact;
    /**
     * (experimental) Returns a CloudFormation stack artifact from this assembly.
     *
     * @param artifactId the artifact id of the stack (can be obtained through `stack.artifactId`).
     * @returns a `CloudFormationStackArtifact` object.
     * @experimental
     * @throws if there is no stack artifact with that id
     */
    getStackArtifact(artifactId: string): CloudFormationStackArtifact;
    private tryGetArtifactRecursively;
    /**
     * (experimental) Returns all the stacks, including the ones in nested assemblies.
     *
     * @experimental
     */
    get stacksRecursively(): CloudFormationStackArtifact[];
    /**
     * (experimental) Returns a nested assembly artifact.
     *
     * @param artifactId The artifact ID of the nested assembly.
     * @experimental
     */
    getNestedAssemblyArtifact(artifactId: string): NestedCloudAssemblyArtifact;
    /**
     * (experimental) Returns a nested assembly.
     *
     * @param artifactId The artifact ID of the nested assembly.
     * @experimental
     */
    getNestedAssembly(artifactId: string): CloudAssembly;
    /**
     * (experimental) Returns the tree metadata artifact from this assembly.
     *
     * @returns a `TreeCloudArtifact` object if there is one defined in the manifest, `undefined` otherwise.
     * @experimental
     * @throws if there is no metadata artifact by that name
     */
    tree(): TreeCloudArtifact | undefined;
    /**
     * @returns all the CloudFormation stack artifacts that are included in this assembly.
     * @experimental
     */
    get stacks(): CloudFormationStackArtifact[];
    /**
     * (experimental) The nested assembly artifacts in this assembly.
     *
     * @experimental
     */
    get nestedAssemblies(): NestedCloudAssemblyArtifact[];
    private validateDeps;
    private renderArtifacts;
}
/**
 * (experimental) Construction properties for CloudAssemblyBuilder.
 *
 * @experimental
 */
export interface CloudAssemblyBuilderProps {
    /**
     * (experimental) Use the given asset output directory.
     *
     * @default - Same as the manifest outdir
     * @experimental
     */
    readonly assetOutdir?: string;
    /**
     * (experimental) If this builder is for a nested assembly, the parent assembly builder.
     *
     * @default - This is a root assembly
     * @experimental
     */
    readonly parentBuilder?: CloudAssemblyBuilder;
}
/**
 * (experimental) Can be used to build a cloud assembly.
 *
 * @experimental
 */
export declare class CloudAssemblyBuilder {
    /**
     * (experimental) The root directory of the resulting cloud assembly.
     *
     * @experimental
     */
    readonly outdir: string;
    /**
     * (experimental) The directory where assets of this Cloud Assembly should be stored.
     *
     * @experimental
     */
    readonly assetOutdir: string;
    private readonly artifacts;
    private readonly missing;
    private readonly parentBuilder?;
    /**
     * (experimental) Initializes a cloud assembly builder.
     *
     * @param outdir The output directory, uses temporary directory if undefined.
     * @experimental
     */
    constructor(outdir?: string, props?: CloudAssemblyBuilderProps);
    /**
     * (experimental) Adds an artifact into the cloud assembly.
     *
     * @param id The ID of the artifact.
     * @param manifest The artifact manifest.
     * @experimental
     */
    addArtifact(id: string, manifest: cxschema.ArtifactManifest): void;
    /**
     * (experimental) Reports that some context is missing in order for this cloud assembly to be fully synthesized.
     *
     * @param missing Missing context information.
     * @experimental
     */
    addMissing(missing: cxschema.MissingContext): void;
    /**
     * (experimental) Finalizes the cloud assembly into the output directory returns a `CloudAssembly` object that can be used to inspect the assembly.
     *
     * @experimental
     */
    buildAssembly(options?: AssemblyBuildOptions): CloudAssembly;
    /**
     * (experimental) Creates a nested cloud assembly.
     *
     * @experimental
     */
    createNestedAssembly(artifactId: string, displayName: string): CloudAssemblyBuilder;
}
/**
 * (deprecated) Backwards compatibility for when `RuntimeInfo` was defined here.
 *
 * This is necessary because its used as an input in the stable
 *
 * @see core.ConstructNode.synth
 * @deprecated moved to package 'cloud-assembly-schema'
 * @aws-cdk /core library.
 */
export interface RuntimeInfo extends cxschema.RuntimeInfo {
}
/**
 * (deprecated) Backwards compatibility for when `MetadataEntry` was defined here.
 *
 * This is necessary because its used as an input in the stable
 *
 * @see core.ConstructNode.metadata
 * @deprecated moved to package 'cloud-assembly-schema'
 * @aws-cdk /core library.
 */
export interface MetadataEntry extends cxschema.MetadataEntry {
}
/**
 * (deprecated) Backwards compatibility for when `MissingContext` was defined here.
 *
 * This is necessary because its used as an input in the stable
 *
 * @see core.Stack.reportMissingContext
 * @deprecated moved to package 'cloud-assembly-schema'
 * @aws-cdk /core library.
 */
export interface MissingContext {
    /**
     * (deprecated) The missing context key.
     *
     * @deprecated
     */
    readonly key: string;
    /**
     * (deprecated) The provider from which we expect this context key to be obtained.
     *
     * (This is the old untyped definition, which is necessary for backwards compatibility.
     * See cxschema for a type definition.)
     *
     * @deprecated
     */
    readonly provider: string;
    /**
     * (deprecated) A set of provider-specific options.
     *
     * (This is the old untyped definition, which is necessary for backwards compatibility.
     * See cxschema for a type definition.)
     *
     * @deprecated
     */
    readonly props: Record<string, any>;
}
/**
 * @experimental
 */
export interface AssemblyBuildOptions {
    /**
     * (deprecated) Include the specified runtime information (module versions) in manifest.
     *
     * @default - if this option is not specified, runtime info will not be included
     * @deprecated All template modifications that should result from this should
     * have already been inserted into the template.
     */
    readonly runtimeInfo?: RuntimeInfo;
}
