"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ASSET_PREFIX_SEPARATOR = exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = exports.ASSET_RESOURCE_METADATA_PATH_KEY = exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = void 0;
/**
 * If this is set in the context, the aws:asset:xxx metadata entries will not be
 * added to the template. This is used, for example, when we run integrationt
 * tests.
 */
exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = 'aws:cdk:enable-asset-metadata';
/**
 * Metadata added to the CloudFormation template entries that map local assets
 * to resources.
 */
exports.ASSET_RESOURCE_METADATA_PATH_KEY = 'aws:asset:path';
exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = 'aws:asset:property';
/**
 * Separator string that separates the prefix separator from the object key separator.
 *
 * Asset keys will look like:
 *
 *    /assets/MyConstruct12345678/||abcdef12345.zip
 *
 * This allows us to encode both the prefix and the full location in a single
 * CloudFormation Template Parameter.
 */
exports.ASSET_PREFIX_SEPARATOR = '||';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzZXRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXNzZXRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7O0dBSUc7QUFDVSxRQUFBLHVDQUF1QyxHQUFHLCtCQUErQixDQUFDO0FBQ3ZGOzs7R0FHRztBQUNVLFFBQUEsZ0NBQWdDLEdBQUcsZ0JBQWdCLENBQUM7QUFDcEQsUUFBQSxvQ0FBb0MsR0FBRyxvQkFBb0IsQ0FBQztBQUN6RTs7Ozs7Ozs7O0dBU0c7QUFDVSxRQUFBLHNCQUFzQixHQUFHLElBQUksQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogSWYgdGhpcyBpcyBzZXQgaW4gdGhlIGNvbnRleHQsIHRoZSBhd3M6YXNzZXQ6eHh4IG1ldGFkYXRhIGVudHJpZXMgd2lsbCBub3QgYmVcbiAqIGFkZGVkIHRvIHRoZSB0ZW1wbGF0ZS4gVGhpcyBpcyB1c2VkLCBmb3IgZXhhbXBsZSwgd2hlbiB3ZSBydW4gaW50ZWdyYXRpb250XG4gKiB0ZXN0cy5cbiAqL1xuZXhwb3J0IGNvbnN0IEFTU0VUX1JFU09VUkNFX01FVEFEQVRBX0VOQUJMRURfQ09OVEVYVCA9ICdhd3M6Y2RrOmVuYWJsZS1hc3NldC1tZXRhZGF0YSc7XG4vKipcbiAqIE1ldGFkYXRhIGFkZGVkIHRvIHRoZSBDbG91ZEZvcm1hdGlvbiB0ZW1wbGF0ZSBlbnRyaWVzIHRoYXQgbWFwIGxvY2FsIGFzc2V0c1xuICogdG8gcmVzb3VyY2VzLlxuICovXG5leHBvcnQgY29uc3QgQVNTRVRfUkVTT1VSQ0VfTUVUQURBVEFfUEFUSF9LRVkgPSAnYXdzOmFzc2V0OnBhdGgnO1xuZXhwb3J0IGNvbnN0IEFTU0VUX1JFU09VUkNFX01FVEFEQVRBX1BST1BFUlRZX0tFWSA9ICdhd3M6YXNzZXQ6cHJvcGVydHknO1xuLyoqXG4gKiBTZXBhcmF0b3Igc3RyaW5nIHRoYXQgc2VwYXJhdGVzIHRoZSBwcmVmaXggc2VwYXJhdG9yIGZyb20gdGhlIG9iamVjdCBrZXkgc2VwYXJhdG9yLlxuICpcbiAqIEFzc2V0IGtleXMgd2lsbCBsb29rIGxpa2U6XG4gKlxuICogICAgL2Fzc2V0cy9NeUNvbnN0cnVjdDEyMzQ1Njc4L3x8YWJjZGVmMTIzNDUuemlwXG4gKlxuICogVGhpcyBhbGxvd3MgdXMgdG8gZW5jb2RlIGJvdGggdGhlIHByZWZpeCBhbmQgdGhlIGZ1bGwgbG9jYXRpb24gaW4gYSBzaW5nbGVcbiAqIENsb3VkRm9ybWF0aW9uIFRlbXBsYXRlIFBhcmFtZXRlci5cbiAqL1xuZXhwb3J0IGNvbnN0IEFTU0VUX1BSRUZJWF9TRVBBUkFUT1IgPSAnfHwnO1xuIl19