"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedCloudAssemblyArtifact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
const cloud_assembly_1 = require("../cloud-assembly");
/**
 * (experimental) Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @experimental
 */
class NestedCloudAssemblyArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * @experimental
     */
    constructor(assembly, name, artifact) {
        var _b;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties || {});
        this.directoryName = properties.directoryName;
        this.displayName = (_b = properties.displayName) !== null && _b !== void 0 ? _b : name;
    }
    /**
     * (experimental) Full path to the nested assembly directory.
     *
     * @experimental
     */
    get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
    }
    /**
     * (experimental) The nested Assembly.
     *
     * @experimental
     */
    get nestedAssembly() {
        if (!this._nestedAssembly) {
            this._nestedAssembly = new cloud_assembly_1.CloudAssembly(this.fullPath);
        }
        return this._nestedAssembly;
    }
}
exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact;
_a = JSII_RTTI_SYMBOL_1;
NestedCloudAssemblyArtifact[_a] = { fqn: "monocdk.cx_api.NestedCloudAssemblyArtifact", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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