"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationStackArtifact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cxschema = require("../../../cloud-assembly-schema"); // Automatically re-written from '@aws-cdk/cloud-assembly-schema'
const cloud_artifact_1 = require("../cloud-artifact");
const environment_1 = require("../environment");
/**
 * @experimental
 */
class CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * @experimental
     */
    constructor(assembly, artifactId, artifact) {
        var _b, _c;
        super(assembly, artifactId, artifact);
        const properties = (this.manifest.properties || {});
        if (!properties.templateFile) {
            throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
            throw new Error('Invalid CloudFormation stack artifact. Missing environment');
        }
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = (_b = properties.parameters) !== null && _b !== void 0 ? _b : {};
        // We get the tags from 'properties' if available (cloud assembly format >= 6.0.0), otherwise
        // from the stack metadata
        this.tags = (_c = properties.tags) !== null && _c !== void 0 ? _c : this.tagsFromMetadata();
        this.assumeRoleArn = properties.assumeRoleArn;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
        this.terminationProtection = properties.terminationProtection;
        this.validateOnSynth = properties.validateOnSynth;
        this.stackName = properties.stackName || artifactId;
        this.assets = this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map(e => e.data);
        this.displayName = this.stackName === artifactId
            ? this.stackName
            : `${artifactId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
    }
    /**
     * (experimental) Full path to the template file.
     *
     * @experimental
     */
    get templateFullPath() {
        return path.join(this.assembly.directory, this.templateFile);
    }
    /**
     * (experimental) The CloudFormation template for this stack.
     *
     * @experimental
     */
    get template() {
        if (this._template === undefined) {
            this._template = JSON.parse(fs.readFileSync(this.templateFullPath, 'utf-8'));
        }
        return this._template;
    }
    tagsFromMetadata() {
        var _b;
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS)) {
            for (const tag of ((_b = metadataEntry.data) !== null && _b !== void 0 ? _b : [])) {
                ret[tag.key] = tag.value;
            }
        }
        return ret;
    }
}
exports.CloudFormationStackArtifact = CloudFormationStackArtifact;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationStackArtifact[_a] = { fqn: "monocdk.cx_api.CloudFormationStackArtifact", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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