import * as cxschema from "../../../cloud-assembly-schema";
import { CloudArtifact } from '../cloud-artifact';
import { CloudAssembly } from '../cloud-assembly';
import { Environment } from '../environment';
/**
 * @experimental
 */
export declare class CloudFormationStackArtifact extends CloudArtifact {
    /**
     * (experimental) The file name of the template.
     *
     * @experimental
     */
    readonly templateFile: string;
    /**
     * (experimental) The original name as defined in the CDK app.
     *
     * @experimental
     */
    readonly originalName: string;
    /**
     * (experimental) Any assets associated with this stack.
     *
     * @experimental
     */
    readonly assets: cxschema.AssetMetadataEntry[];
    /**
     * (experimental) CloudFormation parameters to pass to the stack.
     *
     * @experimental
     */
    readonly parameters: {
        [id: string]: string;
    };
    /**
     * (experimental) CloudFormation tags to pass to the stack.
     *
     * @experimental
     */
    readonly tags: {
        [id: string]: string;
    };
    /**
     * (experimental) The physical name of this stack.
     *
     * @experimental
     */
    readonly stackName: string;
    /**
     * (experimental) A string that represents this stack.
     *
     * Should only be used in user interfaces.
     * If the stackName and artifactId are the same, it will just return that. Otherwise,
     * it will return something like "<artifactId> (<stackName>)"
     *
     * @experimental
     */
    readonly displayName: string;
    /**
     * (deprecated) The physical name of this stack.
     *
     * @deprecated renamed to `stackName`
     */
    readonly name: string;
    /**
     * (experimental) The environment into which to deploy this artifact.
     *
     * @experimental
     */
    readonly environment: Environment;
    /**
     * (experimental) The role that needs to be assumed to deploy the stack.
     *
     * @default - No role is assumed (current credentials are used)
     * @experimental
     */
    readonly assumeRoleArn?: string;
    /**
     * (experimental) The role that is passed to CloudFormation to execute the change set.
     *
     * @default - No role is passed (currently assumed role/credentials are used)
     * @experimental
     */
    readonly cloudFormationExecutionRoleArn?: string;
    /**
     * (experimental) If the stack template has already been included in the asset manifest, its asset URL.
     *
     * @default - Not uploaded yet, upload just before deploying
     * @experimental
     */
    readonly stackTemplateAssetObjectUrl?: string;
    /**
     * (experimental) Version of bootstrap stack required to deploy this stack.
     *
     * @default - No bootstrap stack required
     * @experimental
     */
    readonly requiresBootstrapStackVersion?: number;
    /**
     * (experimental) Name of SSM parameter with bootstrap stack version.
     *
     * @default - Discover SSM parameter by reading stack
     * @experimental
     */
    readonly bootstrapStackVersionSsmParameter?: string;
    /**
     * (experimental) Whether termination protection is enabled for this stack.
     *
     * @experimental
     */
    readonly terminationProtection?: boolean;
    /**
     * (experimental) Whether this stack should be validated by the CLI after synthesis.
     *
     * @default - false
     * @experimental
     */
    readonly validateOnSynth?: boolean;
    private _template;
    /**
     * @experimental
     */
    constructor(assembly: CloudAssembly, artifactId: string, artifact: cxschema.ArtifactManifest);
    /**
     * (experimental) Full path to the template file.
     *
     * @experimental
     */
    get templateFullPath(): string;
    /**
     * (experimental) The CloudFormation template for this stack.
     *
     * @experimental
     */
    get template(): any;
    private tagsFromMetadata;
}
