import * as ec2 from "../../../aws-ec2";
import * as lambda from "../../../aws-lambda";
import * as logs from "../../../aws-logs";
import { Duration } from "../../../core";
import { Construct } from 'constructs';
import { CustomResourceProviderConfig, ICustomResourceProvider } from "../../../aws-cloudformation";
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Initialization properties for the `Provider` construct.
 *
 * @experimental
 */
export interface ProviderProps {
    /**
     * (experimental) The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE).
     *
     * This function is responsible to begin the requested resource operation
     * (CREATE/UPDATE/DELETE) and return any additional properties to add to the
     * event, which will later be passed to `isComplete`. The `PhysicalResourceId`
     * property must be included in the response.
     *
     * @experimental
     */
    readonly onEventHandler: lambda.IFunction;
    /**
     * (experimental) The AWS Lambda function to invoke in order to determine if the operation is complete.
     *
     * This function will be called immediately after `onEvent` and then
     * periodically based on the configured query interval as long as it returns
     * `false`. If the function still returns `false` and the alloted timeout has
     * passed, the operation will fail.
     *
     * @default - provider is synchronous. This means that the `onEvent` handler
     * is expected to finish all lifecycle operations within the initial invocation.
     * @experimental
     */
    readonly isCompleteHandler?: lambda.IFunction;
    /**
     * (experimental) Time between calls to the `isComplete` handler which determines if the resource has been stabilized.
     *
     * The first `isComplete` will be called immediately after `handler` and then
     * every `queryInterval` seconds, and until `timeout` has been reached or until
     * `isComplete` returns `true`.
     *
     * @default Duration.seconds(5)
     * @experimental
     */
    readonly queryInterval?: Duration;
    /**
     * (experimental) Total timeout for the entire operation.
     *
     * The maximum timeout is 2 hours (yes, it can exceed the AWS Lambda 15 minutes)
     *
     * @default Duration.minutes(30)
     * @experimental
     */
    readonly totalTimeout?: Duration;
    /**
     * (experimental) The number of days framework log events are kept in CloudWatch Logs.
     *
     * When
     * updating this property, unsetting it doesn't remove the log retention policy.
     * To remove the retention policy, set the value to `INFINITE`.
     *
     * @default logs.RetentionDays.INFINITE
     * @experimental
     */
    readonly logRetention?: logs.RetentionDays;
    /**
     * (experimental) The vpc to provision the lambda functions in.
     *
     * @default - functions are not provisioned inside a vpc.
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Which subnets from the VPC to place the lambda functions in.
     *
     * Only used if 'vpc' is supplied. Note: internet access for Lambdas
     * requires a NAT gateway, so picking Public subnets is not allowed.
     *
     * @default - the Vpc default strategy if not specified
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) Security groups to attach to the provider functions.
     *
     * Only used if 'vpc' is supplied
     *
     * @default - If `vpc` is not supplied, no security groups are attached. Otherwise, a dedicated security
     * group is created for each function.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
}
/**
 * (experimental) Defines an AWS CloudFormation custom resource provider.
 *
 * @experimental
 */
export declare class Provider extends CoreConstruct implements ICustomResourceProvider {
    /**
     * (experimental) The user-defined AWS Lambda function which is invoked for all resource lifecycle operations (CREATE/UPDATE/DELETE).
     *
     * @experimental
     */
    readonly onEventHandler: lambda.IFunction;
    /**
     * (experimental) The user-defined AWS Lambda function which is invoked asynchronously in order to determine if the operation is complete.
     *
     * @experimental
     */
    readonly isCompleteHandler?: lambda.IFunction;
    /**
     * (experimental) The service token to use in order to define custom resources that are backed by this provider.
     *
     * @experimental
     */
    readonly serviceToken: string;
    private readonly entrypoint;
    private readonly logRetention?;
    private readonly vpc?;
    private readonly vpcSubnets?;
    private readonly securityGroups?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ProviderProps);
    /**
     * (deprecated) Called by `CustomResource` which uses this provider.
     *
     * @deprecated use `provider.serviceToken` instead
     */
    bind(_scope: CoreConstruct): CustomResourceProviderConfig;
    private createFunction;
}
