import { TagType } from './cfn-resource';
/**
 * (experimental) Interface to implement tags.
 *
 * @experimental
 */
export interface ITaggable {
    /**
     * (experimental) TagManager to set, remove and format tags.
     *
     * @experimental
     */
    readonly tags: TagManager;
}
/**
 * (experimental) Options to configure TagManager behavior.
 *
 * @experimental
 */
export interface TagManagerOptions {
    /**
     * (experimental) The name of the property in CloudFormation for these tags.
     *
     * Normally this is `tags`, but Cognito UserPool uses UserPoolTags
     *
     * @default "tags"
     * @experimental
     */
    readonly tagPropertyName?: string;
}
/**
 * (experimental) TagManager facilitates a common implementation of tagging for Constructs.
 *
 * @experimental
 */
export declare class TagManager {
    /**
     * (experimental) Check whether the given construct is Taggable.
     *
     * @experimental
     */
    static isTaggable(construct: any): construct is ITaggable;
    /**
     * (experimental) The property name for tag values.
     *
     * Normally this is `tags` but some resources choose a different name. Cognito
     * UserPool uses UserPoolTags
     *
     * @experimental
     */
    readonly tagPropertyName: string;
    private readonly tags;
    private readonly priorities;
    private readonly tagFormatter;
    private readonly resourceTypeName;
    private readonly initialTagPriority;
    /**
     * @experimental
     */
    constructor(tagType: TagType, resourceTypeName: string, tagStructure?: any, options?: TagManagerOptions);
    /**
     * (experimental) Adds the specified tag to the array of tags.
     *
     * @experimental
     */
    setTag(key: string, value: string, priority?: number, applyToLaunchedInstances?: boolean): void;
    /**
     * (experimental) Removes the specified tag from the array if it exists.
     *
     * @param key The tag to remove.
     * @param priority The priority of the remove operation.
     * @experimental
     */
    removeTag(key: string, priority: number): void;
    /**
     * (experimental) Renders tags into the proper format based on TagType.
     *
     * @experimental
     */
    renderTags(): any;
    /**
     * (experimental) Render the tags in a readable format.
     *
     * @experimental
     */
    tagValues(): Record<string, string>;
    /**
     * (experimental) Determine if the aspect applies here.
     *
     * Looks at the include and exclude resourceTypeName arrays to determine if
     * the aspect applies here
     *
     * @experimental
     */
    applyTagAspectHere(include?: string[], exclude?: string[]): boolean;
    /**
     * (experimental) Returns true if there are any tags defined.
     *
     * @experimental
     */
    hasTags(): boolean;
    private _setTag;
    private get sortedTags();
}
