import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
/**
 * (experimental) Encodes information how a certain Stack should be deployed.
 *
 * @experimental
 */
export interface IStackSynthesizer {
    /**
     * (experimental) Bind to the stack this environment is going to be used on.
     *
     * Must be called before any of the other methods are called.
     *
     * @experimental
     */
    bind(stack: Stack): void;
    /**
     * (experimental) Register a File Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @experimental
     */
    addFileAsset(asset: FileAssetSource): FileAssetLocation;
    /**
     * (experimental) Register a Docker Image Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @experimental
     */
    addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    /**
     * (experimental) Synthesize the associated stack to the session.
     *
     * @experimental
     */
    synthesize(session: ISynthesisSession): void;
}
