import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
import { IStackSynthesizer } from './types';
/**
 * (experimental) Base class for implementing an IStackSynthesizer.
 *
 * This class needs to exist to provide public surface area for external
 * implementations of stack synthesizers. The protected methods give
 * access to functions that are otherwise @_internal to the framework
 * and could not be accessed by external implementors.
 *
 * @experimental
 */
export declare abstract class StackSynthesizer implements IStackSynthesizer {
    /**
     * (experimental) Bind to the stack this environment is going to be used on.
     *
     * Must be called before any of the other methods are called.
     *
     * @experimental
     */
    abstract bind(stack: Stack): void;
    /**
     * (experimental) Register a File Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @experimental
     */
    abstract addFileAsset(asset: FileAssetSource): FileAssetLocation;
    /**
     * (experimental) Register a Docker Image Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @experimental
     */
    abstract addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    /**
     * (experimental) Synthesize the associated stack to the session.
     *
     * @experimental
     */
    abstract synthesize(session: ISynthesisSession): void;
    /**
     * (experimental) Have the stack write out its template.
     *
     * @experimental
     */
    protected synthesizeStackTemplate(stack: Stack, session: ISynthesisSession): void;
    /**
     * (experimental) Write the stack artifact to the session.
     *
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     *
     * @experimental
     */
    protected emitStackArtifact(stack: Stack, session: ISynthesisSession, options?: SynthesizeStackArtifactOptions): void;
}
/**
 * (experimental) Stack artifact options.
 *
 * A subset of `cxschema.AwsCloudFormationStackProperties` of optional settings that need to be
 * configurable by synthesizers, plus `additionalDependencies`.
 *
 * @experimental
 */
export interface SynthesizeStackArtifactOptions {
    /**
     * (experimental) Identifiers of additional dependencies.
     *
     * @default - No additional dependencies
     * @experimental
     */
    readonly additionalDependencies?: string[];
    /**
     * (experimental) Values for CloudFormation stack parameters that should be passed when the stack is deployed.
     *
     * @default - No parameters
     * @experimental
     */
    readonly parameters?: {
        [id: string]: string;
    };
    /**
     * (experimental) The role that needs to be assumed to deploy the stack.
     *
     * @default - No role is assumed (current credentials are used)
     * @experimental
     */
    readonly assumeRoleArn?: string;
    /**
     * (experimental) The role that is passed to CloudFormation to execute the change set.
     *
     * @default - No role is passed (currently assumed role/credentials are used)
     * @experimental
     */
    readonly cloudFormationExecutionRoleArn?: string;
    /**
     * (experimental) If the stack template has already been included in the asset manifest, its asset URL.
     *
     * @default - Not uploaded yet, upload just before deploying
     * @experimental
     */
    readonly stackTemplateAssetObjectUrl?: string;
    /**
     * (experimental) Version of bootstrap stack required to deploy this stack.
     *
     * @default - No bootstrap stack required
     * @experimental
     */
    readonly requiresBootstrapStackVersion?: number;
    /**
     * (experimental) SSM parameter where the bootstrap stack version number can be found.
     *
     * Only used if `requiresBootstrapStackVersion` is set.
     *
     * - If this value is not set, the bootstrap stack name must be known at
     *    deployment time so the stack version can be looked up from the stack
     *    outputs.
     * - If this value is set, the bootstrap stack can have any name because
     *    we won't need to look it up.
     *
     * @default - Bootstrap stack version number looked up
     * @experimental
     */
    readonly bootstrapStackVersionSsmParameter?: string;
}
