import { CfnDynamicReference } from './cfn-dynamic-reference';
import { CfnParameter } from './cfn-parameter';
import { Intrinsic } from './private/intrinsic';
/**
 * (experimental) Work with secret values in the CDK.
 *
 * Secret values in the CDK (such as those retrieved from SecretsManager) are
 * represented as regular strings, just like other values that are only
 * available at deployment time.
 *
 * To help you avoid accidental mistakes which would lead to you putting your
 * secret values directly into a CloudFormation template, constructs that take
 * secret values will not allow you to pass in a literal secret value. They do
 * so by calling `Secret.assertSafeSecret()`.
 *
 * You can escape the check by calling `Secret.plainText()`, but doing
 * so is highly discouraged.
 *
 * @experimental
 */
export declare class SecretValue extends Intrinsic {
    /**
     * (experimental) Construct a literal secret value for use with secret-aware constructs.
     *
     * *Do not use this method for any secrets that you care about.*
     *
     * The only reasonable use case for using this method is when you are testing.
     *
     * @experimental
     */
    static plainText(secret: string): SecretValue;
    /**
     * (experimental) Creates a `SecretValue` with a value which is dynamically loaded from AWS Secrets Manager.
     *
     * @param secretId The ID or ARN of the secret.
     * @param options Options.
     * @experimental
     */
    static secretsManager(secretId: string, options?: SecretsManagerSecretOptions): SecretValue;
    /**
     * (experimental) Use a secret value stored from a Systems Manager (SSM) parameter.
     *
     * @param parameterName The name of the parameter in the Systems Manager Parameter Store.
     * @param version An integer that specifies the version of the parameter to use.
     * @experimental
     */
    static ssmSecure(parameterName: string, version: string): SecretValue;
    /**
     * (experimental) Obtain the secret value through a CloudFormation dynamic reference.
     *
     * If possible, use `SecretValue.ssmSecure` or `SecretValue.secretsManager` directly.
     *
     * @param ref The dynamic reference to use.
     * @experimental
     */
    static cfnDynamicReference(ref: CfnDynamicReference): SecretValue;
    /**
     * (experimental) Obtain the secret value through a CloudFormation parameter.
     *
     * Generally, this is not a recommended approach. AWS Secrets Manager is the
     * recommended way to reference secrets.
     *
     * @param param The CloudFormation parameter to use.
     * @experimental
     */
    static cfnParameter(param: CfnParameter): SecretValue;
}
/**
 * (experimental) Options for referencing a secret value from Secrets Manager.
 *
 * @experimental
 */
export interface SecretsManagerSecretOptions {
    /**
     * (experimental) Specified the secret version that you want to retrieve by the staging label attached to the version.
     *
     * Can specify at most one of `versionId` and `versionStage`.
     *
     * @default AWSCURRENT
     * @experimental
     */
    readonly versionStage?: string;
    /**
     * (experimental) Specifies the unique identifier of the version of the secret you want to use.
     *
     * Can specify at most one of `versionId` and `versionStage`.
     *
     * @default AWSCURRENT
     * @experimental
     */
    readonly versionId?: string;
    /**
     * (experimental) The key of a JSON field to retrieve.
     *
     * This can only be used if the secret
     * stores a JSON object.
     *
     * @default - returns all the content stored in the Secrets Manager secret.
     * @experimental
     */
    readonly jsonField?: string;
}
