"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.constructInfoFromStack = exports.constructInfoFromConstruct = void 0;
const stack_1 = require("../stack");
const stage_1 = require("../stage");
const ALLOWED_FQN_PREFIXES = [
    // SCOPES
    '@aws-cdk/', '@aws-cdk-containers/', '@aws-solutions-konstruk/', '@aws-solutions-constructs/', '@amzn/',
    // PACKAGES
    'aws-rfdk.', 'aws-cdk-lib.', 'monocdk.',
];
/**
 * Symbol for accessing jsii runtime information
 *
 * Introduced in jsii 1.19.0, cdk 1.90.0.
 */
const JSII_RUNTIME_SYMBOL = Symbol.for('jsii.rtti');
function constructInfoFromConstruct(construct) {
    const jsiiRuntimeInfo = Object.getPrototypeOf(construct).constructor[JSII_RUNTIME_SYMBOL];
    if (typeof jsiiRuntimeInfo === 'object'
        && jsiiRuntimeInfo !== null
        && typeof jsiiRuntimeInfo.fqn === 'string'
        && typeof jsiiRuntimeInfo.version === 'string') {
        return { fqn: jsiiRuntimeInfo.fqn, version: jsiiRuntimeInfo.version };
    }
    else if (jsiiRuntimeInfo) {
        // There is something defined, but doesn't match our expectations. Fail fast and hard.
        throw new Error(`malformed jsii runtime info for construct: '${construct.node.path}'`);
    }
    return undefined;
}
exports.constructInfoFromConstruct = constructInfoFromConstruct;
/**
 * For a given stack, walks the tree and finds the runtime info for all constructs within the tree.
 * Returns the unique list of construct info present in the stack,
 * as long as the construct fully-qualified names match the defined allow list.
 */
function constructInfoFromStack(stack) {
    const isDefined = (value) => value !== undefined;
    const allConstructInfos = constructsInStack(stack)
        .map(construct => constructInfoFromConstruct(construct))
        .filter(isDefined)
        .filter(info => ALLOWED_FQN_PREFIXES.find(prefix => info.fqn.startsWith(prefix)));
    // Adds the jsii runtime as a psuedo construct for reporting purposes.
    allConstructInfos.push({
        fqn: 'jsii-runtime.Runtime',
        version: getJsiiAgentVersion(),
    });
    // Filter out duplicate values
    const uniqKeys = new Set();
    return allConstructInfos.filter(construct => {
        const constructKey = `${construct.fqn}@${construct.version}`;
        const isDuplicate = uniqKeys.has(constructKey);
        uniqKeys.add(constructKey);
        return !isDuplicate;
    });
}
exports.constructInfoFromStack = constructInfoFromStack;
/**
 * Returns all constructs under the parent construct (including the parent),
 * stopping when it reaches a boundary of another stack (e.g., Stack, Stage, NestedStack).
 */
function constructsInStack(construct) {
    const constructs = [construct];
    construct.node.children
        .filter(child => !stage_1.Stage.isStage(child) && !stack_1.Stack.isStack(child))
        .forEach(child => constructs.push(...constructsInStack(child)));
    return constructs;
}
function getJsiiAgentVersion() {
    let jsiiAgent = process.env.JSII_AGENT;
    // if JSII_AGENT is not specified, we will assume this is a node.js runtime
    // and plug in our node.js version
    if (!jsiiAgent) {
        jsiiAgent = `node.js/${process.version}`;
    }
    // Sanitize the agent to remove characters which might mess with the downstream
    // prefix encoding & decoding. In particular the .NET jsii agent takes a form like:
    // DotNet/5.0.3/.NETCoreApp,Version=v3.1/1.0.0.0
    // The `,` in the above messes with the prefix decoding when reporting the analytics.
    jsiiAgent = jsiiAgent.replace(/[^a-z0-9.-/=_]/gi, '-');
    return jsiiAgent;
}
//# sourceMappingURL=data:application/json;base64,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