"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Intrinsic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stack_trace_1 = require("../stack-trace");
const token_1 = require("../token");
/**
 * (experimental) Token subclass that represents values intrinsic to the target document language.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Intrinsic {
    /**
     * @experimental
     */
    constructor(value, options = {}) {
        var _b;
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = ((_b = options.stackTrace) !== null && _b !== void 0 ? _b : true) ? stack_trace_1.captureStackTrace() : [];
        this.value = value;
    }
    /**
     * (experimental) Produce the Token's value at resolution time.
     *
     * @experimental
     */
    resolve(_context) {
        return this.value;
    }
    /**
     * (experimental) Convert an instance of this Token to a string.
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     *
     * @experimental
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * (experimental) Turn this Token into JSON.
     *
     * Called automatically when JSON.stringify() is called on a Token.
     *
     * @experimental
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return '<unresolved-token>';
    }
    /**
     * (experimental) Creates a throwable Error object that contains the token creation stack trace.
     *
     * @param message Error message.
     * @experimental
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join('\n    at ')}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
_a = JSII_RTTI_SYMBOL_1;
Intrinsic[_a] = { fqn: "monocdk.Intrinsic", version: "1.106.1" };
function isFunction(x) {
    return typeof x === 'function';
}
//# sourceMappingURL=data:application/json;base64,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