"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/**
 * Parses the value of "Value" and reflects it back as attribute.
 */
async function handler(event) {
    // dispatch based on resource type
    if (event.ResourceType === "Custom::AWSCDKCfnJson" /* CFN_JSON */) {
        return cfnJsonHandler(event);
    }
    if (event.ResourceType === "Custom::AWSCDKCfnJsonStringify" /* CFN_JSON_STRINGIFY */) {
        return cfnJsonStringifyHandler(event);
    }
    throw new Error(`unexpected resource type "${event.ResourceType}`);
}
exports.handler = handler;
function cfnJsonHandler(event) {
    return {
        Data: {
            Value: JSON.parse(event.ResourceProperties.Value),
        },
    };
}
function cfnJsonStringifyHandler(event) {
    return {
        Data: {
            Value: JSON.stringify(event.ResourceProperties.Value),
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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