"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUtils = exports.CfnUtilsProvider = void 0;
const construct_compat_1 = require("../construct-compat");
const custom_resource_1 = require("../custom-resource");
const custom_resource_provider_1 = require("../custom-resource-provider");
/**
 * A custom resource provider for CFN utilities such as `CfnJson`.
 */
class CfnUtilsProvider extends construct_compat_1.Construct {
    static getOrCreate(scope) {
        return custom_resource_provider_1.CustomResourceProvider.getOrCreate(scope, 'AWSCDKCfnUtilsProvider', {
            runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_12_X,
            codeDirectory: `${__dirname}/cfn-utils-provider`,
        });
    }
}
exports.CfnUtilsProvider = CfnUtilsProvider;
/**
 * Utility functions provided by the CfnUtilsProvider
 */
class CfnUtils {
    /**
     * Encode a structure to JSON at CloudFormation deployment time
     *
     * This would have been suitable for the JSON-encoding of abitrary structures, however:
     *
     * - It uses a custom resource to do the encoding, and we'd rather not use a custom
     *   resource if we can avoid it.
     * - It cannot be used to encode objects where the keys of the objects can contain
     *   tokens--because those cannot be represented in the JSON encoding that CloudFormation
     *   templates use.
     *
     * This helper is used by `CloudFormationLang.toJSON()` if and only if it encounters
     * objects that cannot be stringified any other way.
     */
    static stringify(scope, id, value) {
        const resource = new custom_resource_1.CustomResource(scope, id, {
            serviceToken: CfnUtilsProvider.getOrCreate(scope),
            resourceType: "Custom::AWSCDKCfnJsonStringify" /* CFN_JSON_STRINGIFY */,
            properties: {
                Value: value,
            },
        });
        return resource.getAttString('Value');
    }
}
exports.CfnUtils = CfnUtils;
//# sourceMappingURL=data:application/json;base64,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