"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
/**
 * A simple cache class.
 *
 * Must be declared at the top of the file because we're going to use it statically in the
 * AssetStaging class.
 */
class Cache {
    constructor() {
        this.cache = new Map();
    }
    /**
     * Clears the cache
     */
    clear() {
        this.cache.clear();
    }
    /**
     * Get a value from the cache or calculate it
     */
    obtain(cacheKey, calcFn) {
        let value = this.cache.get(cacheKey);
        if (value) {
            return value;
        }
        value = calcFn();
        this.cache.set(cacheKey, value);
        return value;
    }
}
exports.Cache = Cache;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjYWNoZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTs7Ozs7R0FLRztBQUNILE1BQWEsS0FBSztJQUFsQjtRQUNZLFVBQUssR0FBRyxJQUFJLEdBQUcsRUFBYSxDQUFDO0lBbUJ6QyxDQUFDO0lBbEJHOztPQUVHO0lBQ0ksS0FBSztRQUNSLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7SUFDdkIsQ0FBQztJQUNEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFFBQWdCLEVBQUUsTUFBZTtRQUMzQyxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUNyQyxJQUFJLEtBQUssRUFBRTtZQUNQLE9BQU8sS0FBSyxDQUFDO1NBQ2hCO1FBQ0QsS0FBSyxHQUFHLE1BQU0sRUFBRSxDQUFDO1FBQ2pCLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNoQyxPQUFPLEtBQUssQ0FBQztJQUNqQixDQUFDO0NBQ0o7QUFwQkQsc0JBb0JDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBBIHNpbXBsZSBjYWNoZSBjbGFzcy5cbiAqXG4gKiBNdXN0IGJlIGRlY2xhcmVkIGF0IHRoZSB0b3Agb2YgdGhlIGZpbGUgYmVjYXVzZSB3ZSdyZSBnb2luZyB0byB1c2UgaXQgc3RhdGljYWxseSBpbiB0aGVcbiAqIEFzc2V0U3RhZ2luZyBjbGFzcy5cbiAqL1xuZXhwb3J0IGNsYXNzIENhY2hlPEE+IHtcbiAgICBwcml2YXRlIGNhY2hlID0gbmV3IE1hcDxzdHJpbmcsIEE+KCk7XG4gICAgLyoqXG4gICAgICogQ2xlYXJzIHRoZSBjYWNoZVxuICAgICAqL1xuICAgIHB1YmxpYyBjbGVhcigpIHtcbiAgICAgICAgdGhpcy5jYWNoZS5jbGVhcigpO1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBHZXQgYSB2YWx1ZSBmcm9tIHRoZSBjYWNoZSBvciBjYWxjdWxhdGUgaXRcbiAgICAgKi9cbiAgICBwdWJsaWMgb2J0YWluKGNhY2hlS2V5OiBzdHJpbmcsIGNhbGNGbjogKCkgPT4gQSk6IEEge1xuICAgICAgICBsZXQgdmFsdWUgPSB0aGlzLmNhY2hlLmdldChjYWNoZUtleSk7XG4gICAgICAgIGlmICh2YWx1ZSkge1xuICAgICAgICAgICAgcmV0dXJuIHZhbHVlO1xuICAgICAgICB9XG4gICAgICAgIHZhbHVlID0gY2FsY0ZuKCk7XG4gICAgICAgIHRoaXMuY2FjaGUuc2V0KGNhY2hlS2V5LCB2YWx1ZSk7XG4gICAgICAgIHJldHVybiB2YWx1ZTtcbiAgICB9XG59XG4iXX0=