"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileAssetParameters = void 0;
const cfn_parameter_1 = require("../cfn-parameter");
const construct_compat_1 = require("../construct-compat");
class FileAssetParameters extends construct_compat_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        // add parameters for s3 bucket and s3 key. those will be set by
        // the toolkit or by CI/CD when the stack is deployed and will include
        // the name of the bucket and the S3 key where the code lives.
        this.bucketNameParameter = new cfn_parameter_1.CfnParameter(this, 'S3Bucket', {
            type: 'String',
            description: `S3 bucket for asset "${id}"`,
        });
        this.objectKeyParameter = new cfn_parameter_1.CfnParameter(this, 'S3VersionKey', {
            type: 'String',
            description: `S3 key for asset version "${id}"`,
        });
        this.artifactHashParameter = new cfn_parameter_1.CfnParameter(this, 'ArtifactHash', {
            description: `Artifact hash for asset "${id}"`,
            type: 'String',
        });
    }
}
exports.FileAssetParameters = FileAssetParameters;
//# sourceMappingURL=data:application/json;base64,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