"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shouldFollow = void 0;
const fs = require("fs");
const path = require("path");
const options_1 = require("./options");
/**
 * Determines whether a symlink should be followed or not, based on a FollowMode.
 *
 * @param mode       the FollowMode.
 * @param sourceRoot the root of the source tree.
 * @param realPath   the real path of the target of the symlink.
 *
 * @returns true if the link should be followed.
 */
function shouldFollow(mode, sourceRoot, realPath) {
    switch (mode) {
        case options_1.SymlinkFollowMode.ALWAYS:
            return fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.EXTERNAL:
            return !_isInternal() && fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.BLOCK_EXTERNAL:
            return _isInternal() && fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.NEVER:
            return false;
        default:
            throw new Error(`Unsupported FollowMode: ${mode}`);
    }
    function _isInternal() {
        return path.resolve(realPath).startsWith(path.resolve(sourceRoot));
    }
}
exports.shouldFollow = shouldFollow;
//# sourceMappingURL=data:application/json;base64,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