/**
 * (experimental) Determines how symlinks are followed.
 *
 * @experimental
 */
export declare enum SymlinkFollowMode {
    /**
     * (experimental) Never follow symlinks.
     *
     * @experimental
     */
    NEVER = "never",
    /**
     * (experimental) Materialize all symlinks, whether they are internal or external to the source directory.
     *
     * @experimental
     */
    ALWAYS = "always",
    /**
     * (experimental) Only follows symlinks that are external to the source directory.
     *
     * @experimental
     */
    EXTERNAL = "external",
    /**
     * (experimental) Forbids source from having any symlinks pointing outside of the source tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     *
     * @experimental
     */
    BLOCK_EXTERNAL = "internal-only"
}
/**
 * (experimental) Determines the ignore behavior to use.
 *
 * @experimental
 */
export declare enum IgnoreMode {
    /**
     * (experimental) Ignores file paths based on simple glob patterns.
     *
     * This is the default for file assets.
     *
     * It is also the default for Docker image assets, unless the '@aws-cdk/aws-ecr-assets:dockerIgnoreSupport'
     * context flag is set.
     *
     * @experimental
     */
    GLOB = "glob",
    /**
     * (experimental) Ignores file paths based on the [`.gitignore specification`](https://git-scm.com/docs/gitignore).
     *
     * @experimental
     */
    GIT = "git",
    /**
     * (experimental) Ignores file paths based on the [`.dockerignore specification`](https://docs.docker.com/engine/reference/builder/#dockerignore-file).
     *
     * This is the default for Docker image assets if the '@aws-cdk/aws-ecr-assets:dockerIgnoreSupport'
     * context flag is set.
     *
     * @experimental
     */
    DOCKER = "docker"
}
interface FileOptions {
    /**
     * (experimental) Glob patterns to exclude from the copy.
     *
     * @default - nothing is excluded
     * @experimental
     */
    readonly exclude?: string[];
    /**
     * (experimental) The ignore behavior to use for exclude patterns.
     *
     * @default IgnoreMode.GLOB
     * @experimental
     */
    readonly ignoreMode?: IgnoreMode;
}
/**
 * (experimental) Options applied when copying directories.
 *
 * @experimental
 */
export interface CopyOptions extends FileOptions {
    /**
     * (experimental) A strategy for how to handle symlinks.
     *
     * @default SymlinkFollowMode.NEVER
     * @experimental
     */
    readonly follow?: SymlinkFollowMode;
}
/**
 * (experimental) Options applied when copying directories into the staging location.
 *
 * @experimental
 */
export interface FileCopyOptions extends FileOptions {
    /**
     * (experimental) A strategy for how to handle symlinks.
     *
     * @default SymlinkFollowMode.NEVER
     * @experimental
     */
    readonly followSymlinks?: SymlinkFollowMode;
}
interface ExtraHashOptions {
    /**
     * (experimental) Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
     *
     * @default - hash is only based on source content
     * @experimental
     */
    readonly extraHash?: string;
}
/**
 * (experimental) Options related to calculating source hash.
 *
 * @experimental
 */
export interface FingerprintOptions extends CopyOptions, ExtraHashOptions {
}
/**
 * (experimental) Options related to calculating source hash.
 *
 * @experimental
 */
export interface FileFingerprintOptions extends FileCopyOptions, ExtraHashOptions {
}
export {};
