"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const os = require("os");
const path = require("path");
const copy_1 = require("./copy");
const fingerprint_1 = require("./fingerprint");
__exportStar(require("./ignore"), exports);
__exportStar(require("./options"), exports);
/**
 * (experimental) File system utilities.
 *
 * @experimental
 */
class FileSystem {
    /**
     * (experimental) Copies an entire directory structure.
     *
     * @param srcDir Source directory.
     * @param destDir Destination directory.
     * @param options options.
     * @param rootDir Root directory to calculate exclusions from.
     * @experimental
     */
    static copyDirectory(srcDir, destDir, options = {}, rootDir) {
        return copy_1.copyDirectory(srcDir, destDir, options, rootDir);
    }
    /**
     * (experimental) Produces fingerprint based on the contents of a single file or an entire directory tree.
     *
     * The fingerprint will also include:
     * 1. An extra string if defined in `options.extra`.
     * 2. The set of exclude patterns, if defined in `options.exclude`
     * 3. The symlink follow mode value.
     *
     * @param fileOrDirectory The directory or file to fingerprint.
     * @param options Fingerprinting options.
     * @experimental
     */
    static fingerprint(fileOrDirectory, options = {}) {
        return fingerprint_1.fingerprint(fileOrDirectory, options);
    }
    /**
     * (experimental) Checks whether a directory is empty.
     *
     * @param dir The directory to check.
     * @experimental
     */
    static isEmpty(dir) {
        return fs.readdirSync(dir).length === 0;
    }
    /**
     * (experimental) The real path of the system temp directory.
     *
     * @experimental
     */
    static get tmpdir() {
        if (FileSystem._tmpdir) {
            return FileSystem._tmpdir;
        }
        FileSystem._tmpdir = fs.realpathSync(os.tmpdir());
        return FileSystem._tmpdir;
    }
    /**
     * (experimental) Creates a unique temporary directory in the **system temp directory**.
     *
     * @param prefix A prefix for the directory name.
     * @experimental
     */
    static mkdtemp(prefix) {
        return fs.mkdtempSync(path.join(FileSystem.tmpdir, prefix));
    }
}
exports.FileSystem = FileSystem;
_a = JSII_RTTI_SYMBOL_1;
FileSystem[_a] = { fqn: "monocdk.FileSystem", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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