import { CopyOptions } from './options';
/**
 * (experimental) Represents file path ignoring behavior.
 *
 * @experimental
 */
export declare abstract class IgnoreStrategy {
    /**
     * (experimental) Ignores file paths based on simple glob patterns.
     *
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered.
     * @returns `GlobIgnorePattern` associated with the given patterns.
     * @experimental
     */
    static glob(absoluteRootPath: string, patterns: string[]): GlobIgnoreStrategy;
    /**
     * (experimental) Ignores file paths based on the [`.gitignore specification`](https://git-scm.com/docs/gitignore).
     *
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered.
     * @returns `GitIgnorePattern` associated with the given patterns.
     * @experimental
     */
    static git(absoluteRootPath: string, patterns: string[]): GitIgnoreStrategy;
    /**
     * (experimental) Ignores file paths based on the [`.dockerignore specification`](https://docs.docker.com/engine/reference/builder/#dockerignore-file).
     *
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered.
     * @returns `DockerIgnorePattern` associated with the given patterns.
     * @experimental
     */
    static docker(absoluteRootPath: string, patterns: string[]): DockerIgnoreStrategy;
    /**
     * (experimental) Creates an IgnoreStrategy based on the `ignoreMode` and `exclude` in a `CopyOptions`.
     *
     * @param options the `CopyOptions` to create the `IgnoreStrategy` from.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered.
     * @returns `IgnoreStrategy` based on the `CopyOptions`
     * @experimental
     */
    static fromCopyOptions(options: CopyOptions, absoluteRootPath: string): IgnoreStrategy;
    /**
     * (experimental) Adds another pattern.
     *
     * @experimental
     * @params pattern the pattern to add
     */
    abstract add(pattern: string): void;
    /**
     * (experimental) Determines whether a given file path should be ignored or not.
     *
     * @param absoluteFilePath absolute file path to be assessed against the pattern.
     * @returns `true` if the file should be ignored
     * @experimental
     */
    abstract ignores(absoluteFilePath: string): boolean;
}
/**
 * (experimental) Ignores file paths based on simple glob patterns.
 *
 * @experimental
 */
export declare class GlobIgnoreStrategy extends IgnoreStrategy {
    private readonly absoluteRootPath;
    private readonly patterns;
    /**
     * @experimental
     */
    constructor(absoluteRootPath: string, patterns: string[]);
    /**
     * (experimental) Adds another pattern.
     *
     * @experimental
     * @params pattern the pattern to add
     */
    add(pattern: string): void;
    /**
     * (experimental) Determines whether a given file path should be ignored or not.
     *
     * @param absoluteFilePath absolute file path to be assessed against the pattern.
     * @returns `true` if the file should be ignored
     * @experimental
     */
    ignores(absoluteFilePath: string): boolean;
}
/**
 * (experimental) Ignores file paths based on the [`.gitignore specification`](https://git-scm.com/docs/gitignore).
 *
 * @experimental
 */
export declare class GitIgnoreStrategy extends IgnoreStrategy {
    private readonly absoluteRootPath;
    private readonly ignore;
    /**
     * @experimental
     */
    constructor(absoluteRootPath: string, patterns: string[]);
    /**
     * (experimental) Adds another pattern.
     *
     * @experimental
     * @params pattern the pattern to add
     */
    add(pattern: string): void;
    /**
     * (experimental) Determines whether a given file path should be ignored or not.
     *
     * @param absoluteFilePath absolute file path to be assessed against the pattern.
     * @returns `true` if the file should be ignored
     * @experimental
     */
    ignores(absoluteFilePath: string): boolean;
}
/**
 * (experimental) Ignores file paths based on the [`.dockerignore specification`](https://docs.docker.com/engine/reference/builder/#dockerignore-file).
 *
 * @experimental
 */
export declare class DockerIgnoreStrategy extends IgnoreStrategy {
    private readonly absoluteRootPath;
    private readonly ignore;
    /**
     * @experimental
     */
    constructor(absoluteRootPath: string, patterns: string[]);
    /**
     * (experimental) Adds another pattern.
     *
     * @experimental
     * @params pattern the pattern to add
     */
    add(pattern: string): void;
    /**
     * (experimental) Determines whether a given file path should be ignored or not.
     *
     * @param absoluteFilePath absolute file path to be assessed against the pattern.
     * @returns `true` if the file should be ignored
     * @experimental
     */
    ignores(absoluteFilePath: string): boolean;
}
