"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyDirectory = void 0;
const fs = require("fs");
const path = require("path");
const ignore_1 = require("./ignore");
const options_1 = require("./options");
const utils_1 = require("./utils");
function copyDirectory(srcDir, destDir, options = {}, rootDir) {
    var _a;
    const follow = (_a = options.follow) !== null && _a !== void 0 ? _a : options_1.SymlinkFollowMode.EXTERNAL;
    rootDir = rootDir || srcDir;
    const ignoreStrategy = ignore_1.IgnoreStrategy.fromCopyOptions(options, rootDir);
    if (!fs.statSync(srcDir).isDirectory()) {
        throw new Error(`${srcDir} is not a directory`);
    }
    const files = fs.readdirSync(srcDir);
    for (const file of files) {
        const sourceFilePath = path.join(srcDir, file);
        if (ignoreStrategy.ignores(sourceFilePath)) {
            continue;
        }
        const destFilePath = path.join(destDir, file);
        let stat = follow === options_1.SymlinkFollowMode.ALWAYS
            ? fs.statSync(sourceFilePath)
            : fs.lstatSync(sourceFilePath);
        if (stat && stat.isSymbolicLink()) {
            const target = fs.readlinkSync(sourceFilePath);
            // determine if this is an external link (i.e. the target's absolute path
            // is outside of the root directory).
            const targetPath = path.normalize(path.resolve(srcDir, target));
            if (utils_1.shouldFollow(follow, rootDir, targetPath)) {
                stat = fs.statSync(sourceFilePath);
            }
            else {
                fs.symlinkSync(target, destFilePath);
                stat = undefined;
            }
        }
        if (stat && stat.isDirectory()) {
            fs.mkdirSync(destFilePath);
            copyDirectory(sourceFilePath, destFilePath, options, rootDir);
            stat = undefined;
        }
        if (stat && stat.isFile()) {
            fs.copyFileSync(sourceFilePath, destFilePath);
            stat = undefined;
        }
    }
}
exports.copyDirectory = copyDirectory;
//# sourceMappingURL=data:application/json;base64,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