/**
 * (experimental) Represents a length of time.
 *
 * The amount can be specified either as a literal value (e.g: `10`) which
 * cannot be negative, or as an unresolved number token.
 *
 * When the amount is passed as a token, unit conversion is not possible.
 *
 * @experimental
 */
export declare class Duration {
    /**
     * (experimental) Create a Duration representing an amount of milliseconds.
     *
     * @param amount the amount of Milliseconds the `Duration` will represent.
     * @returns a new `Duration` representing `amount` ms.
     * @experimental
     */
    static millis(amount: number): Duration;
    /**
     * (experimental) Create a Duration representing an amount of seconds.
     *
     * @param amount the amount of Seconds the `Duration` will represent.
     * @returns a new `Duration` representing `amount` Seconds.
     * @experimental
     */
    static seconds(amount: number): Duration;
    /**
     * (experimental) Create a Duration representing an amount of minutes.
     *
     * @param amount the amount of Minutes the `Duration` will represent.
     * @returns a new `Duration` representing `amount` Minutes.
     * @experimental
     */
    static minutes(amount: number): Duration;
    /**
     * (experimental) Create a Duration representing an amount of hours.
     *
     * @param amount the amount of Hours the `Duration` will represent.
     * @returns a new `Duration` representing `amount` Hours.
     * @experimental
     */
    static hours(amount: number): Duration;
    /**
     * (experimental) Create a Duration representing an amount of days.
     *
     * @param amount the amount of Days the `Duration` will represent.
     * @returns a new `Duration` representing `amount` Days.
     * @experimental
     */
    static days(amount: number): Duration;
    /**
     * (experimental) Parse a period formatted according to the ISO 8601 standard.
     *
     * @param duration an ISO-formtted duration to be parsed.
     * @returns the parsed `Duration`.
     * @see https://www.iso.org/fr/standard/70907.html
     * @experimental
     */
    static parse(duration: string): Duration;
    private readonly amount;
    private readonly unit;
    private constructor();
    /**
     * (experimental) Add two Durations together.
     *
     * @experimental
     */
    plus(rhs: Duration): Duration;
    /**
     * (experimental) Return the total number of milliseconds in this Duration.
     *
     * @returns the value of this `Duration` expressed in Milliseconds.
     * @experimental
     */
    toMilliseconds(opts?: TimeConversionOptions): number;
    /**
     * (experimental) Return the total number of seconds in this Duration.
     *
     * @returns the value of this `Duration` expressed in Seconds.
     * @experimental
     */
    toSeconds(opts?: TimeConversionOptions): number;
    /**
     * (experimental) Return the total number of minutes in this Duration.
     *
     * @returns the value of this `Duration` expressed in Minutes.
     * @experimental
     */
    toMinutes(opts?: TimeConversionOptions): number;
    /**
     * (experimental) Return the total number of hours in this Duration.
     *
     * @returns the value of this `Duration` expressed in Hours.
     * @experimental
     */
    toHours(opts?: TimeConversionOptions): number;
    /**
     * (experimental) Return the total number of days in this Duration.
     *
     * @returns the value of this `Duration` expressed in Days.
     * @experimental
     */
    toDays(opts?: TimeConversionOptions): number;
    /**
     * (experimental) Return an ISO 8601 representation of this period.
     *
     * @returns a string starting with 'P' describing the period
     * @see https://www.iso.org/fr/standard/70907.html
     * @experimental
     */
    toIsoString(): string;
    /**
     * (deprecated) Return an ISO 8601 representation of this period.
     *
     * @returns a string starting with 'P' describing the period
     * @see https://www.iso.org/fr/standard/70907.html
     * @deprecated Use `toIsoString()` instead.
     */
    toISOString(): string;
    /**
     * (experimental) Turn this duration into a human-readable string.
     *
     * @experimental
     */
    toHumanString(): string;
    /**
     * (experimental) Returns a string representation of this `Duration` that is also a Token that cannot be successfully resolved.
     *
     * This
     * protects users against inadvertently stringifying a `Duration` object, when they should have called one of the
     * `to*` methods instead.
     *
     * @experimental
     */
    toString(): string;
    /**
     * Return the duration in a set of whole numbered time components, ordered from largest to smallest
     *
     * Only components != 0 will be returned.
     *
     * Can combine millis and seconds together for the benefit of toIsoString,
     * makes the logic in there simpler.
     */
    private components;
    /**
     * (experimental) Checks if duration is a token or a resolvable object.
     *
     * @experimental
     */
    isUnresolved(): boolean;
    /**
     * (experimental) Returns unit of the duration.
     *
     * @experimental
     */
    unitLabel(): string;
    /**
     * (experimental) Returns stringified number of duration.
     *
     * @experimental
     */
    formatTokenToNumber(): string;
}
/**
 * (experimental) Options for how to convert time to a different unit.
 *
 * @experimental
 */
export interface TimeConversionOptions {
    /**
     * (experimental) If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.
     *
     * @default true
     * @experimental
     */
    readonly integral?: boolean;
}
