"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScopedAws = exports.Aws = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_reference_1 = require("./private/cfn-reference");
const token_1 = require("./token");
const AWS_ACCOUNTID = 'AWS::AccountId';
const AWS_URLSUFFIX = 'AWS::URLSuffix';
const AWS_NOTIFICATIONARNS = 'AWS::NotificationARNs';
const AWS_PARTITION = 'AWS::Partition';
const AWS_REGION = 'AWS::Region';
const AWS_STACKID = 'AWS::StackId';
const AWS_STACKNAME = 'AWS::StackName';
const AWS_NOVALUE = 'AWS::NoValue';
/**
 * (experimental) Accessor for pseudo parameters.
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 *
 * @experimental
 */
class Aws {
    constructor() { }
}
exports.Aws = Aws;
_a = JSII_RTTI_SYMBOL_1;
Aws[_a] = { fqn: "monocdk.Aws", version: "1.106.1" };
/**
 * @experimental
 */
Aws.ACCOUNT_ID = pseudoString(AWS_ACCOUNTID);
/**
 * @experimental
 */
Aws.URL_SUFFIX = pseudoString(AWS_URLSUFFIX);
/**
 * @experimental
 */
Aws.NOTIFICATION_ARNS = token_1.Token.asList({ Ref: AWS_NOTIFICATIONARNS }, { displayHint: AWS_NOTIFICATIONARNS });
/**
 * @experimental
 */
Aws.PARTITION = pseudoString(AWS_PARTITION);
/**
 * @experimental
 */
Aws.REGION = pseudoString(AWS_REGION);
/**
 * @experimental
 */
Aws.STACK_ID = pseudoString(AWS_STACKID);
/**
 * @experimental
 */
Aws.STACK_NAME = pseudoString(AWS_STACKNAME);
/**
 * @experimental
 */
Aws.NO_VALUE = pseudoString(AWS_NOVALUE);
/**
 * (experimental) Accessor for scoped pseudo parameters.
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 *
 * @experimental
 */
class ScopedAws {
    /**
     * @experimental
     */
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * @experimental
     */
    get accountId() {
        return this.asString(AWS_ACCOUNTID);
    }
    /**
     * @experimental
     */
    get urlSuffix() {
        return this.asString(AWS_URLSUFFIX);
    }
    /**
     * @experimental
     */
    get notificationArns() {
        return token_1.Token.asList(cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope), {
            displayHint: AWS_NOTIFICATIONARNS,
        });
    }
    /**
     * @experimental
     */
    get partition() {
        return this.asString(AWS_PARTITION);
    }
    /**
     * @experimental
     */
    get region() {
        return this.asString(AWS_REGION);
    }
    /**
     * @experimental
     */
    get stackId() {
        return this.asString(AWS_STACKID);
    }
    /**
     * @experimental
     */
    get stackName() {
        return this.asString(AWS_STACKNAME);
    }
    asString(name) {
        return token_1.Token.asString(cfn_reference_1.CfnReference.forPseudo(name, this.scope), { displayHint: name });
    }
}
exports.ScopedAws = ScopedAws;
_b = JSII_RTTI_SYMBOL_1;
ScopedAws[_b] = { fqn: "monocdk.ScopedAws", version: "1.106.1" };
function pseudoString(name) {
    // we don't want any ':' in the serialized form,
    // as ':' is the ARN separator,
    // and so we don't want ARN components
    // (which these CFN references like AWS::Partition certainly can be)
    // to contain ':'s themselves
    return token_1.Token.asString({ Ref: name }, { displayHint: name.replace('::', '.') });
}
//# sourceMappingURL=data:application/json;base64,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