import { Construct } from 'constructs';
import { CfnRefElement } from './cfn-element';
/**
 * @experimental
 */
export interface CfnMappingProps {
    /**
     * (experimental) Mapping of key to a set of corresponding set of named values.
     *
     * The key identifies a map of name-value pairs and must be unique within the mapping.
     *
     * For example, if you want to set values based on a region, you can create a mapping
     * that uses the region name as a key and contains the values you want to specify for
     * each specific region.
     *
     * @default - No mapping.
     * @experimental
     */
    readonly mapping?: {
        [k1: string]: {
            [k2: string]: any;
        };
    };
}
/**
 * (experimental) Represents a CloudFormation mapping.
 *
 * @experimental
 */
export declare class CfnMapping extends CfnRefElement {
    private mapping;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: CfnMappingProps);
    /**
     * (experimental) Sets a value in the map based on the two keys.
     *
     * @experimental
     */
    setValue(key1: string, key2: string, value: any): void;
    /**
     * @returns A reference to a value in the map based on the two keys.
     * @experimental
     */
    findInMap(key1: string, key2: string): string;
    /**
     * @internal
     */
    _toCloudFormation(): object;
}
