import { Construct } from 'constructs';
import { Reference } from './reference';
import { IResolvable, IResolveContext } from './resolvable';
import { Construct as CoreConstruct } from './construct-compat';
/**
 * @experimental
 */
export interface CfnJsonProps {
    /**
     * (experimental) The value to resolve.
     *
     * Can be any JavaScript object, including tokens and
     * references in keys or values.
     *
     * @experimental
     */
    readonly value: any;
}
/**
 * (experimental) Captures a synthesis-time JSON object a CloudFormation reference which resolves during deployment to the resolved values of the JSON object.
 *
 * The main use case for this is to overcome a limitation in CloudFormation that
 * does not allow using intrinsic functions as dictionary keys (because
 * dictionary keys in JSON must be strings). Specifically this is common in IAM
 * conditions such as `StringEquals: { lhs: "rhs" }` where you want "lhs" to be
 * a reference.
 *
 * This object is resolvable, so it can be used as a value.
 *
 * This construct is backed by a custom resource.
 *
 * @experimental
 */
export declare class CfnJson extends CoreConstruct implements IResolvable {
    /**
     * (experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.
     *
     * This may return an array with a single informational element indicating how
     * to get this property populated, if it was skipped for performance reasons.
     *
     * @experimental
     */
    readonly creationStack: string[];
    /**
     * (experimental) An Fn::GetAtt to the JSON object passed through `value` and resolved during synthesis.
     *
     * Normally there is no need to use this property since `CfnJson` is an
     * IResolvable, so it can be simply used as a value.
     *
     * @experimental
     */
    readonly value: Reference;
    private readonly jsonString;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CfnJsonProps);
    /**
     * (experimental) This is required in case someone JSON.stringifys an object which refrences this object. Otherwise, we'll get a cyclic JSON reference.
     *
     * @experimental
     */
    toJSON(): string;
    /**
     * (experimental) Produce the Token's value at resolution time.
     *
     * @experimental
     */
    resolve(_: IResolveContext): any;
}
