import { Intrinsic } from './private/intrinsic';
/**
 * (experimental) Properties for a Dynamic Reference.
 *
 * @experimental
 */
export interface CfnDynamicReferenceProps {
    /**
     * (experimental) The service to retrieve the dynamic reference from.
     *
     * @experimental
     */
    readonly service: CfnDynamicReferenceService;
    /**
     * (experimental) The reference key of the dynamic reference.
     *
     * @experimental
     */
    readonly referenceKey: string;
}
/**
 * (experimental) References a dynamically retrieved value.
 *
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
 * @experimental
 */
export declare class CfnDynamicReference extends Intrinsic {
    /**
     * @experimental
     */
    constructor(service: CfnDynamicReferenceService, key: string);
}
/**
 * (experimental) The service to retrieve the dynamic reference from.
 *
 * @experimental
 */
export declare enum CfnDynamicReferenceService {
    /**
     * (experimental) Plaintext value stored in AWS Systems Manager Parameter Store.
     *
     * @experimental
     */
    SSM = "ssm",
    /**
     * (experimental) Secure string stored in AWS Systems Manager Parameter Store.
     *
     * @experimental
     */
    SSM_SECURE = "ssm-secure",
    /**
     * (experimental) Secret stored in AWS Secrets Manager.
     *
     * @experimental
     */
    SECRETS_MANAGER = "secretsmanager"
}
