"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCodeDeployBlueGreenHook = exports.CfnTrafficRoutingType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_hook_1 = require("./cfn-hook");
const util_1 = require("./util");
/**
 * (experimental) The possible types of traffic shifting for the blue-green deployment configuration.
 *
 * The type of the {@link CfnTrafficRoutingConfig.type} property.
 *
 * @experimental
 */
var CfnTrafficRoutingType;
(function (CfnTrafficRoutingType) {
    CfnTrafficRoutingType["ALL_AT_ONCE"] = "AllAtOnce";
    CfnTrafficRoutingType["TIME_BASED_CANARY"] = "TimeBasedCanary";
    CfnTrafficRoutingType["TIME_BASED_LINEAR"] = "TimeBasedLinear";
})(CfnTrafficRoutingType = exports.CfnTrafficRoutingType || (exports.CfnTrafficRoutingType = {}));
/**
 * (experimental) A CloudFormation Hook for CodeDeploy blue-green ECS deployments.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html#blue-green-template-reference
 * @experimental
 */
class CfnCodeDeployBlueGreenHook extends cfn_hook_1.CfnHook {
    /**
     * (experimental) Creates a new CodeDeploy blue-green ECS Hook.
     *
     * @param scope the scope to create the hook in (usually the containing Stack object).
     * @param id the identifier of the construct - will be used to generate the logical ID of the Hook.
     * @param props the properties of the Hook.
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'AWS::CodeDeploy::BlueGreen',
        });
        this._serviceRole = props.serviceRole;
        this._applications = props.applications;
        this._trafficRoutingConfig = props.trafficRoutingConfig;
        this._additionalOptions = props.additionalOptions;
        this._lifecycleEventHooks = props.lifecycleEventHooks;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, hookAttributes, options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        hookAttributes = hookAttributes || {};
        const hookProperties = options.parser.parseValue(hookAttributes.Properties);
        return new CfnCodeDeployBlueGreenHook(scope, id, {
            serviceRole: hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.ServiceRole,
            applications: (_b = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.Applications) === null || _b === void 0 ? void 0 : _b.map(applicationFromCloudFormation),
            trafficRoutingConfig: {
                type: (_c = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _c === void 0 ? void 0 : _c.Type,
                timeBasedCanary: {
                    stepPercentage: (_e = (_d = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _d === void 0 ? void 0 : _d.TimeBasedCanary) === null || _e === void 0 ? void 0 : _e.StepPercentage,
                    bakeTimeMins: (_g = (_f = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _f === void 0 ? void 0 : _f.TimeBasedCanary) === null || _g === void 0 ? void 0 : _g.BakeTimeMins,
                },
                timeBasedLinear: {
                    stepPercentage: (_j = (_h = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _h === void 0 ? void 0 : _h.TimeBasedLinear) === null || _j === void 0 ? void 0 : _j.StepPercentage,
                    bakeTimeMins: (_l = (_k = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _k === void 0 ? void 0 : _k.TimeBasedLinear) === null || _l === void 0 ? void 0 : _l.BakeTimeMins,
                },
            },
            additionalOptions: {
                terminationWaitTimeInMinutes: (_m = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.AdditionalOptions) === null || _m === void 0 ? void 0 : _m.TerminationWaitTimeInMinutes,
            },
            lifecycleEventHooks: {
                beforeInstall: (_o = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _o === void 0 ? void 0 : _o.BeforeInstall,
                afterInstall: (_p = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _p === void 0 ? void 0 : _p.AfterInstall,
                afterAllowTestTraffic: (_q = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _q === void 0 ? void 0 : _q.AfterAllowTestTraffic,
                beforeAllowTraffic: (_r = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _r === void 0 ? void 0 : _r.BeforeAllowTraffic,
                afterAllowTraffic: (_s = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _s === void 0 ? void 0 : _s.AfterAllowTraffic,
            },
        });
        function applicationFromCloudFormation(app) {
            var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
            const target = findResource((_b = app === null || app === void 0 ? void 0 : app.Target) === null || _b === void 0 ? void 0 : _b.LogicalID);
            const taskDefinitions = (_d = (_c = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _c === void 0 ? void 0 : _c.TaskDefinitions) === null || _d === void 0 ? void 0 : _d.map((td) => findResource(td));
            const taskSets = (_f = (_e = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _e === void 0 ? void 0 : _e.TaskSets) === null || _f === void 0 ? void 0 : _f.map((ts) => findResource(ts));
            const prodTrafficRoute = findResource((_j = (_h = (_g = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _g === void 0 ? void 0 : _g.TrafficRouting) === null || _h === void 0 ? void 0 : _h.ProdTrafficRoute) === null || _j === void 0 ? void 0 : _j.LogicalID);
            const testTrafficRoute = findResource((_m = (_l = (_k = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _k === void 0 ? void 0 : _k.TrafficRouting) === null || _l === void 0 ? void 0 : _l.TestTrafficRoute) === null || _m === void 0 ? void 0 : _m.LogicalID);
            const targetGroups = (_q = (_p = (_o = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _o === void 0 ? void 0 : _o.TrafficRouting) === null || _p === void 0 ? void 0 : _p.TargetGroups) === null || _q === void 0 ? void 0 : _q.map((tg) => findResource(tg));
            return {
                target: {
                    type: (_r = app === null || app === void 0 ? void 0 : app.Target) === null || _r === void 0 ? void 0 : _r.Type,
                    logicalId: target === null || target === void 0 ? void 0 : target.logicalId,
                },
                ecsAttributes: {
                    taskDefinitions: taskDefinitions === null || taskDefinitions === void 0 ? void 0 : taskDefinitions.map(td => td === null || td === void 0 ? void 0 : td.logicalId),
                    taskSets: taskSets === null || taskSets === void 0 ? void 0 : taskSets.map(ts => ts === null || ts === void 0 ? void 0 : ts.logicalId),
                    trafficRouting: {
                        prodTrafficRoute: {
                            type: (_u = (_t = (_s = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _s === void 0 ? void 0 : _s.TrafficRouting) === null || _t === void 0 ? void 0 : _t.ProdTrafficRoute) === null || _u === void 0 ? void 0 : _u.Type,
                            logicalId: prodTrafficRoute === null || prodTrafficRoute === void 0 ? void 0 : prodTrafficRoute.logicalId,
                        },
                        testTrafficRoute: {
                            type: (_x = (_w = (_v = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _v === void 0 ? void 0 : _v.TrafficRouting) === null || _w === void 0 ? void 0 : _w.TestTrafficRoute) === null || _x === void 0 ? void 0 : _x.Type,
                            logicalId: testTrafficRoute === null || testTrafficRoute === void 0 ? void 0 : testTrafficRoute.logicalId,
                        },
                        targetGroups: targetGroups === null || targetGroups === void 0 ? void 0 : targetGroups.map((tg) => tg === null || tg === void 0 ? void 0 : tg.logicalId),
                    },
                },
            };
        }
        function findResource(logicalId) {
            if (logicalId == null) {
                return undefined;
            }
            const ret = options.parser.finder.findResource(logicalId);
            if (!ret) {
                throw new Error(`Hook '${id}' references resource '${logicalId}' that was not found in the template`);
            }
            return ret;
        }
    }
    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     *
     * @experimental
     */
    get serviceRole() {
        return this._serviceRole;
    }
    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     *
     * @experimental
     */
    set serviceRole(serviceRole) {
        this._serviceRole = serviceRole;
    }
    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     *
     * @experimental
     */
    get applications() {
        return this._applications;
    }
    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     *
     * @experimental
     */
    set applications(value) {
        this._applications = value;
    }
    /**
     * (experimental) Traffic routing configuration settings.
     *
     * @default - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     * @experimental
     */
    get trafficRoutingConfig() {
        return this._trafficRoutingConfig;
    }
    /**
     * (experimental) Traffic routing configuration settings.
     *
     * @default - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     * @experimental
     */
    set trafficRoutingConfig(value) {
        this._trafficRoutingConfig = value;
    }
    /**
     * (experimental) Additional options for the blue/green deployment.
     *
     * @default - no additional options
     * @experimental
     */
    get additionalOptions() {
        return this._additionalOptions;
    }
    /**
     * (experimental) Additional options for the blue/green deployment.
     *
     * @default - no additional options
     * @experimental
     */
    set additionalOptions(value) {
        this._additionalOptions = value;
    }
    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     *
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {@link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     *
     * @default - no lifecycle event hooks
     * @experimental
     */
    get lifecycleEventHooks() {
        return this._lifecycleEventHooks;
    }
    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     *
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {@link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     *
     * @default - no lifecycle event hooks
     * @experimental
     */
    set lifecycleEventHooks(value) {
        this._lifecycleEventHooks = value;
    }
    /**
     * @experimental
     */
    renderProperties(_props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        return {
            ServiceRole: this.serviceRole,
            Applications: this.applications.map((app) => ({
                Target: {
                    Type: app.target.type,
                    LogicalID: app.target.logicalId,
                },
                ECSAttributes: {
                    TaskDefinitions: app.ecsAttributes.taskDefinitions,
                    TaskSets: app.ecsAttributes.taskSets,
                    TrafficRouting: {
                        ProdTrafficRoute: {
                            Type: app.ecsAttributes.trafficRouting.prodTrafficRoute.type,
                            LogicalID: app.ecsAttributes.trafficRouting.prodTrafficRoute.logicalId,
                        },
                        TestTrafficRoute: {
                            Type: app.ecsAttributes.trafficRouting.testTrafficRoute.type,
                            LogicalID: app.ecsAttributes.trafficRouting.testTrafficRoute.logicalId,
                        },
                        TargetGroups: app.ecsAttributes.trafficRouting.targetGroups,
                    },
                },
            })),
            TrafficRoutingConfig: util_1.undefinedIfAllValuesAreEmpty({
                Type: (_b = this.trafficRoutingConfig) === null || _b === void 0 ? void 0 : _b.type,
                TimeBasedCanary: util_1.undefinedIfAllValuesAreEmpty({
                    StepPercentage: (_d = (_c = this.trafficRoutingConfig) === null || _c === void 0 ? void 0 : _c.timeBasedCanary) === null || _d === void 0 ? void 0 : _d.stepPercentage,
                    BakeTimeMins: (_f = (_e = this.trafficRoutingConfig) === null || _e === void 0 ? void 0 : _e.timeBasedCanary) === null || _f === void 0 ? void 0 : _f.bakeTimeMins,
                }),
                TimeBasedLinear: util_1.undefinedIfAllValuesAreEmpty({
                    StepPercentage: (_h = (_g = this.trafficRoutingConfig) === null || _g === void 0 ? void 0 : _g.timeBasedLinear) === null || _h === void 0 ? void 0 : _h.stepPercentage,
                    BakeTimeMins: (_k = (_j = this.trafficRoutingConfig) === null || _j === void 0 ? void 0 : _j.timeBasedLinear) === null || _k === void 0 ? void 0 : _k.bakeTimeMins,
                }),
            }),
            AdditionalOptions: util_1.undefinedIfAllValuesAreEmpty({
                TerminationWaitTimeInMinutes: (_l = this.additionalOptions) === null || _l === void 0 ? void 0 : _l.terminationWaitTimeInMinutes,
            }),
            LifecycleEventHooks: util_1.undefinedIfAllValuesAreEmpty({
                BeforeInstall: (_m = this.lifecycleEventHooks) === null || _m === void 0 ? void 0 : _m.beforeInstall,
                AfterInstall: (_o = this.lifecycleEventHooks) === null || _o === void 0 ? void 0 : _o.afterInstall,
                AfterAllowTestTraffic: (_p = this.lifecycleEventHooks) === null || _p === void 0 ? void 0 : _p.afterAllowTestTraffic,
                BeforeAllowTraffic: (_q = this.lifecycleEventHooks) === null || _q === void 0 ? void 0 : _q.beforeAllowTraffic,
                AfterAllowTraffic: (_r = this.lifecycleEventHooks) === null || _r === void 0 ? void 0 : _r.afterAllowTraffic,
            }),
        };
    }
}
exports.CfnCodeDeployBlueGreenHook = CfnCodeDeployBlueGreenHook;
_a = JSII_RTTI_SYMBOL_1;
CfnCodeDeployBlueGreenHook[_a] = { fqn: "monocdk.CfnCodeDeployBlueGreenHook", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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