import { Construct } from 'constructs';
import { CfnHook } from './cfn-hook';
import { FromCloudFormationOptions } from './cfn-parse';
/**
 * (experimental) The possible types of traffic shifting for the blue-green deployment configuration.
 *
 * The type of the {@link CfnTrafficRoutingConfig.type} property.
 *
 * @experimental
 */
export declare enum CfnTrafficRoutingType {
    /**
     * (experimental) Switch from blue to green at once.
     *
     * @experimental
     */
    ALL_AT_ONCE = "AllAtOnce",
    /**
     * (experimental) Specifies a configuration that shifts traffic from blue to green in two increments.
     *
     * @experimental
     */
    TIME_BASED_CANARY = "TimeBasedCanary",
    /**
     * (experimental) Specifies a configuration that shifts traffic from blue to green in equal increments, with an equal number of minutes between each increment.
     *
     * @experimental
     */
    TIME_BASED_LINEAR = "TimeBasedLinear"
}
/**
 * (experimental) The traffic routing configuration if {@link CfnTrafficRoutingConfig.type} is {@link CfnTrafficRoutingType.TIME_BASED_CANARY}.
 *
 * @experimental
 */
export interface CfnTrafficRoutingTimeBasedCanary {
    /**
     * (experimental) The percentage of traffic to shift in the first increment of a time-based canary deployment.
     *
     * The step percentage must be 14% or greater.
     *
     * @default 15
     * @experimental
     */
    readonly stepPercentage?: number;
    /**
     * (experimental) The number of minutes between the first and second traffic shifts of a time-based canary deployment.
     *
     * @default 5
     * @experimental
     */
    readonly bakeTimeMins?: number;
}
/**
 * (experimental) The traffic routing configuration if {@link CfnTrafficRoutingConfig.type} is {@link CfnTrafficRoutingType.TIME_BASED_LINEAR}.
 *
 * @experimental
 */
export interface CfnTrafficRoutingTimeBasedLinear {
    /**
     * (experimental) The percentage of traffic that is shifted at the start of each increment of a time-based linear deployment.
     *
     * The step percentage must be 14% or greater.
     *
     * @default 15
     * @experimental
     */
    readonly stepPercentage?: number;
    /**
     * (experimental) The number of minutes between the first and second traffic shifts of a time-based linear deployment.
     *
     * @default 5
     * @experimental
     */
    readonly bakeTimeMins?: number;
}
/**
 * (experimental) Traffic routing configuration settings.
 *
 * The type of the {@link CfnCodeDeployBlueGreenHookProps.trafficRoutingConfig} property.
 *
 * @experimental
 */
export interface CfnTrafficRoutingConfig {
    /**
     * (experimental) The type of traffic shifting used by the blue-green deployment configuration.
     *
     * @experimental
     */
    readonly type: CfnTrafficRoutingType;
    /**
     * (experimental) The configuration for traffic routing when {@link type} is {@link CfnTrafficRoutingType.TIME_BASED_CANARY}.
     *
     * @default - none
     * @experimental
     */
    readonly timeBasedCanary?: CfnTrafficRoutingTimeBasedCanary;
    /**
     * (experimental) The configuration for traffic routing when {@link type} is {@link CfnTrafficRoutingType.TIME_BASED_LINEAR}.
     *
     * @default - none
     * @experimental
     */
    readonly timeBasedLinear?: CfnTrafficRoutingTimeBasedLinear;
}
/**
 * (experimental) Additional options for the blue/green deployment.
 *
 * The type of the {@link CfnCodeDeployBlueGreenHookProps.additionalOptions} property.
 *
 * @experimental
 */
export interface CfnCodeDeployBlueGreenAdditionalOptions {
    /**
     * (experimental) Specifies time to wait, in minutes, before terminating the blue resources.
     *
     * @default - 5 minutes
     * @experimental
     */
    readonly terminationWaitTimeInMinutes?: number;
}
/**
 * (experimental) Lifecycle events for blue-green deployments.
 *
 * The type of the {@link CfnCodeDeployBlueGreenHookProps.lifecycleEventHooks} property.
 *
 * @experimental
 */
export interface CfnCodeDeployBlueGreenLifecycleEventHooks {
    /**
     * (experimental) Function to use to run tasks before the replacement task set is created.
     *
     * @default - none
     * @experimental
     */
    readonly beforeInstall?: string;
    /**
     * (experimental) Function to use to run tasks after the replacement task set is created and one of the target groups is associated with it.
     *
     * @default - none
     * @experimental
     */
    readonly afterInstall?: string;
    /**
     * (experimental) Function to use to run tasks after the test listener serves traffic to the replacement task set.
     *
     * @default - none
     * @experimental
     */
    readonly afterAllowTestTraffic?: string;
    /**
     * (experimental) Function to use to run tasks after the second target group is associated with the replacement task set, but before traffic is shifted to the replacement task set.
     *
     * @default - none
     * @experimental
     */
    readonly beforeAllowTraffic?: string;
    /**
     * (experimental) Function to use to run tasks after the second target group serves traffic to the replacement task set.
     *
     * @default - none
     * @experimental
     */
    readonly afterAllowTraffic?: string;
}
/**
 * (experimental) Type of the {@link CfnCodeDeployBlueGreenApplication.target} property.
 *
 * @experimental
 */
export interface CfnCodeDeployBlueGreenApplicationTarget {
    /**
     * (experimental) The resource type of the target being deployed.
     *
     * Right now, the only allowed value is 'AWS::ECS::Service'.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) The logical id of the target resource.
     *
     * @experimental
     */
    readonly logicalId: string;
}
/**
 * (experimental) A traffic route, representing where the traffic is being directed to.
 *
 * @experimental
 */
export interface CfnTrafficRoute {
    /**
     * (experimental) The resource type of the route.
     *
     * Today, the only allowed value is 'AWS::ElasticLoadBalancingV2::Listener'.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) The logical id of the target resource.
     *
     * @experimental
     */
    readonly logicalId: string;
}
/**
 * (experimental) Type of the {@link CfnCodeDeployBlueGreenEcsAttributes.trafficRouting} property.
 *
 * @experimental
 */
export interface CfnTrafficRouting {
    /**
     * (experimental) The listener to be used by your load balancer to direct traffic to your target groups.
     *
     * @experimental
     */
    readonly prodTrafficRoute: CfnTrafficRoute;
    /**
     * (experimental) The listener to be used by your load balancer to direct traffic to your target groups.
     *
     * @experimental
     */
    readonly testTrafficRoute: CfnTrafficRoute;
    /**
     * (experimental) The logical IDs of the blue and green, respectively, AWS::ElasticLoadBalancingV2::TargetGroup target groups.
     *
     * @experimental
     */
    readonly targetGroups: string[];
}
/**
 * (experimental) The attributes of the ECS Service being deployed.
 *
 * Type of the {@link CfnCodeDeployBlueGreenApplication.ecsAttributes} property.
 *
 * @experimental
 */
export interface CfnCodeDeployBlueGreenEcsAttributes {
    /**
     * (experimental) The logical IDs of the blue and green, respectively, AWS::ECS::TaskDefinition task definitions.
     *
     * @experimental
     */
    readonly taskDefinitions: string[];
    /**
     * (experimental) The logical IDs of the blue and green, respectively, AWS::ECS::TaskSet task sets.
     *
     * @experimental
     */
    readonly taskSets: string[];
    /**
     * (experimental) The traffic routing configuration.
     *
     * @experimental
     */
    readonly trafficRouting: CfnTrafficRouting;
}
/**
 * (experimental) The application actually being deployed.
 *
 * Type of the {@link CfnCodeDeployBlueGreenHookProps.applications} property.
 *
 * @experimental
 */
export interface CfnCodeDeployBlueGreenApplication {
    /**
     * (experimental) The target that is being deployed.
     *
     * @experimental
     */
    readonly target: CfnCodeDeployBlueGreenApplicationTarget;
    /**
     * (experimental) The detailed attributes of the deployed target.
     *
     * @experimental
     */
    readonly ecsAttributes: CfnCodeDeployBlueGreenEcsAttributes;
}
/**
 * (experimental) Construction properties of {@link CfnCodeDeployBlueGreenHook}.
 *
 * @experimental
 */
export interface CfnCodeDeployBlueGreenHookProps {
    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     *
     * @experimental
     */
    readonly serviceRole: string;
    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     *
     * @experimental
     */
    readonly applications: CfnCodeDeployBlueGreenApplication[];
    /**
     * (experimental) Traffic routing configuration settings.
     *
     * @default - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     * @experimental
     */
    readonly trafficRoutingConfig?: CfnTrafficRoutingConfig;
    /**
     * (experimental) Additional options for the blue/green deployment.
     *
     * @default - no additional options
     * @experimental
     */
    readonly additionalOptions?: CfnCodeDeployBlueGreenAdditionalOptions;
    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     *
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {@link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     *
     * @default - no lifecycle event hooks
     * @experimental
     */
    readonly lifecycleEventHooks?: CfnCodeDeployBlueGreenLifecycleEventHooks;
}
/**
 * (experimental) A CloudFormation Hook for CodeDeploy blue-green ECS deployments.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html#blue-green-template-reference
 * @experimental
 */
export declare class CfnCodeDeployBlueGreenHook extends CfnHook {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: Construct, id: string, hookAttributes: any, options: FromCloudFormationOptions): CfnCodeDeployBlueGreenHook;
    private _serviceRole;
    private _applications;
    private _trafficRoutingConfig?;
    private _additionalOptions?;
    private _lifecycleEventHooks?;
    /**
     * (experimental) Creates a new CodeDeploy blue-green ECS Hook.
     *
     * @param scope the scope to create the hook in (usually the containing Stack object).
     * @param id the identifier of the construct - will be used to generate the logical ID of the Hook.
     * @param props the properties of the Hook.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CfnCodeDeployBlueGreenHookProps);
    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     *
     * @experimental
     */
    get serviceRole(): string;
    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     *
     * @experimental
     */
    set serviceRole(serviceRole: string);
    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     *
     * @experimental
     */
    get applications(): CfnCodeDeployBlueGreenApplication[];
    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     *
     * @experimental
     */
    set applications(value: CfnCodeDeployBlueGreenApplication[]);
    /**
     * (experimental) Traffic routing configuration settings.
     *
     * @default - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     * @experimental
     */
    get trafficRoutingConfig(): CfnTrafficRoutingConfig | undefined;
    /**
     * (experimental) Traffic routing configuration settings.
     *
     * @default - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     * @experimental
     */
    set trafficRoutingConfig(value: CfnTrafficRoutingConfig | undefined);
    /**
     * (experimental) Additional options for the blue/green deployment.
     *
     * @default - no additional options
     * @experimental
     */
    get additionalOptions(): CfnCodeDeployBlueGreenAdditionalOptions | undefined;
    /**
     * (experimental) Additional options for the blue/green deployment.
     *
     * @default - no additional options
     * @experimental
     */
    set additionalOptions(value: CfnCodeDeployBlueGreenAdditionalOptions | undefined);
    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     *
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {@link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     *
     * @default - no lifecycle event hooks
     * @experimental
     */
    get lifecycleEventHooks(): CfnCodeDeployBlueGreenLifecycleEventHooks | undefined;
    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     *
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {@link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     *
     * @default - no lifecycle event hooks
     * @experimental
     */
    set lifecycleEventHooks(value: CfnCodeDeployBlueGreenLifecycleEventHooks | undefined);
    /**
     * @experimental
     */
    protected renderProperties(_props?: {
        [p: string]: any;
    }): {
        [p: string]: any;
    } | undefined;
}
