"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ASPECTS_SYMBOL = Symbol('cdk-aspects');
/**
 * (experimental) Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.
 *
 * @experimental
 */
class Aspects {
    // TODO(2.0): private readonly _aspects = new Array<IAspect>();
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * (experimental) Returns the `Aspects` object associated with a construct scope.
     *
     * @param scope The scope for which these aspects will apply.
     * @experimental
     */
    static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects(scope);
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * (experimental) Adds an aspect to apply this scope before synthesis.
     *
     * @param aspect The aspect to add.
     * @experimental
     */
    add(aspect) {
        // TODO(2.0): this._aspects.push(aspect);
        this.scope.node._actualNode.applyAspect(aspect);
    }
    /**
     * (experimental) The list of aspects which were directly applied on this scope.
     *
     * @experimental
     */
    get aspects() {
        // TODO(2.0): return  [ ...this._aspects ];
        return [...this.scope.node._actualNode._aspects]; // clone
    }
}
exports.Aspects = Aspects;
_a = JSII_RTTI_SYMBOL_1;
Aspects[_a] = { fqn: "monocdk.Aspects", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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