"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readYamlSync = exports.readJsonSync = void 0;
const fs = require("fs");
const yaml_cfn = require("./private/yaml-cfn");
function readJsonSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return JSON.parse(fileContents.toString());
}
exports.readJsonSync = readJsonSync;
function readYamlSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return yaml_cfn.deserialize(fileContents.toString());
}
exports.readYamlSync = readYamlSync;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsZS11dGlscy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZpbGUtdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEseUJBQXlCO0FBQ3pCLCtDQUErQztBQUMvQyxTQUFnQixZQUFZLENBQUMsUUFBZ0I7SUFDekMsTUFBTSxZQUFZLEdBQUcsRUFBRSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMvQyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7QUFDL0MsQ0FBQztBQUhELG9DQUdDO0FBQ0QsU0FBZ0IsWUFBWSxDQUFDLFFBQWdCO0lBQ3pDLE1BQU0sWUFBWSxHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDL0MsT0FBTyxRQUFRLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO0FBQ3pELENBQUM7QUFIRCxvQ0FHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJztcbmltcG9ydCAqIGFzIHlhbWxfY2ZuIGZyb20gJy4vcHJpdmF0ZS95YW1sLWNmbic7XG5leHBvcnQgZnVuY3Rpb24gcmVhZEpzb25TeW5jKGZpbGVQYXRoOiBzdHJpbmcpOiBhbnkge1xuICAgIGNvbnN0IGZpbGVDb250ZW50cyA9IGZzLnJlYWRGaWxlU3luYyhmaWxlUGF0aCk7XG4gICAgcmV0dXJuIEpTT04ucGFyc2UoZmlsZUNvbnRlbnRzLnRvU3RyaW5nKCkpO1xufVxuZXhwb3J0IGZ1bmN0aW9uIHJlYWRZYW1sU3luYyhmaWxlUGF0aDogc3RyaW5nKTogYW55IHtcbiAgICBjb25zdCBmaWxlQ29udGVudHMgPSBmcy5yZWFkRmlsZVN5bmMoZmlsZVBhdGgpO1xuICAgIHJldHVybiB5YW1sX2Nmbi5kZXNlcmlhbGl6ZShmaWxlQ29udGVudHMudG9TdHJpbmcoKSk7XG59XG4iXX0=