import { Tag } from './metadata-schema';
/**
 * (experimental) Identifier for the context provider.
 *
 * @experimental
 */
export declare enum ContextProvider {
    /**
     * (experimental) AMI provider.
     *
     * @experimental
     */
    AMI_PROVIDER = "ami",
    /**
     * (experimental) AZ provider.
     *
     * @experimental
     */
    AVAILABILITY_ZONE_PROVIDER = "availability-zones",
    /**
     * (experimental) Route53 Hosted Zone provider.
     *
     * @experimental
     */
    HOSTED_ZONE_PROVIDER = "hosted-zone",
    /**
     * (experimental) SSM Parameter Provider.
     *
     * @experimental
     */
    SSM_PARAMETER_PROVIDER = "ssm",
    /**
     * (experimental) VPC Provider.
     *
     * @experimental
     */
    VPC_PROVIDER = "vpc-provider",
    /**
     * (experimental) VPC Endpoint Service AZ Provider.
     *
     * @experimental
     */
    ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = "endpoint-service-availability-zones",
    /**
     * (experimental) Load balancer provider.
     *
     * @experimental
     */
    LOAD_BALANCER_PROVIDER = "load-balancer",
    /**
     * (experimental) Load balancer listener provider.
     *
     * @experimental
     */
    LOAD_BALANCER_LISTENER_PROVIDER = "load-balancer-listener",
    /**
     * (experimental) Security group provider.
     *
     * @experimental
     */
    SECURITY_GROUP_PROVIDER = "security-group"
}
/**
 * (experimental) Query to AMI context provider.
 *
 * @experimental
 */
export interface AmiContextQuery {
    /**
     * (experimental) Account to query.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Region to query.
     *
     * @experimental
     */
    readonly region: string;
    /**
     * (experimental) Owners to DescribeImages call.
     *
     * @default - All owners
     * @experimental
     */
    readonly owners?: string[];
    /**
     * (experimental) Filters to DescribeImages call.
     *
     * @experimental
     */
    readonly filters: {
        [key: string]: string[];
    };
}
/**
 * (experimental) Query to availability zone context provider.
 *
 * @experimental
 */
export interface AvailabilityZonesContextQuery {
    /**
     * (experimental) Query account.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Query region.
     *
     * @experimental
     */
    readonly region: string;
}
/**
 * (experimental) Query to hosted zone context provider.
 *
 * @experimental
 */
export interface HostedZoneContextQuery {
    /**
     * (experimental) Query account.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Query region.
     *
     * @experimental
     */
    readonly region: string;
    /**
     * (experimental) The domain name e.g. example.com to lookup.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) True if the zone you want to find is a private hosted zone.
     *
     * @default false
     * @experimental
     */
    readonly privateZone?: boolean;
    /**
     * (experimental) The VPC ID to that the private zone must be associated with.
     *
     * If you provide VPC ID and privateZone is false, this will return no results
     * and raise an error.
     *
     * @default - Required if privateZone=true
     * @experimental
     */
    readonly vpcId?: string;
}
/**
 * (experimental) Query to SSM Parameter Context Provider.
 *
 * @experimental
 */
export interface SSMParameterContextQuery {
    /**
     * (experimental) Query account.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Query region.
     *
     * @experimental
     */
    readonly region: string;
    /**
     * (experimental) Parameter name to query.
     *
     * @experimental
     */
    readonly parameterName: string;
}
/**
 * (experimental) Query input for looking up a VPC.
 *
 * @experimental
 */
export interface VpcContextQuery {
    /**
     * (experimental) Query account.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Query region.
     *
     * @experimental
     */
    readonly region: string;
    /**
     * (experimental) Filters to apply to the VPC.
     *
     * Filter parameters are the same as passed to DescribeVpcs.
     *
     * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
     * @experimental
     */
    readonly filter: {
        [key: string]: string;
    };
    /**
     * (experimental) Whether to populate the subnetGroups field of the {@link VpcContextResponse}, which contains potentially asymmetric subnet groups.
     *
     * @default false
     * @experimental
     */
    readonly returnAsymmetricSubnets?: boolean;
    /**
     * (experimental) Optional tag for subnet group name.
     *
     * If not provided, we'll look at the aws-cdk:subnet-name tag.
     * If the subnet does not have the specified tag,
     * we'll use its type as the name.
     *
     * @default 'aws-cdk:subnet-name'
     * @experimental
     */
    readonly subnetGroupNameTag?: string;
}
/**
 * (experimental) Query to endpoint service context provider.
 *
 * @experimental
 */
export interface EndpointServiceAvailabilityZonesContextQuery {
    /**
     * (experimental) Query account.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Query region.
     *
     * @experimental
     */
    readonly region: string;
    /**
     * (experimental) Query service name.
     *
     * @experimental
     */
    readonly serviceName: string;
}
/**
 * (experimental) Type of load balancer.
 *
 * @experimental
 */
export declare enum LoadBalancerType {
    /**
     * (experimental) Network load balancer.
     *
     * @experimental
     */
    NETWORK = "network",
    /**
     * (experimental) Application load balancer.
     *
     * @experimental
     */
    APPLICATION = "application"
}
/**
 * (experimental) Filters for selecting load balancers.
 *
 * @experimental
 */
export interface LoadBalancerFilter {
    /**
     * (experimental) Filter load balancers by their type.
     *
     * @experimental
     */
    readonly loadBalancerType: LoadBalancerType;
    /**
     * (experimental) Find by load balancer's ARN.
     *
     * @default - does not search by load balancer arn
     * @experimental
     */
    readonly loadBalancerArn?: string;
    /**
     * (experimental) Match load balancer tags.
     *
     * @default - does not match load balancers by tags
     * @experimental
     */
    readonly loadBalancerTags?: Tag[];
}
/**
 * (experimental) Query input for looking up a load balancer.
 *
 * @experimental
 */
export interface LoadBalancerContextQuery extends LoadBalancerFilter {
    /**
     * (experimental) Query account.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Query region.
     *
     * @experimental
     */
    readonly region: string;
}
/**
 * (experimental) The protocol for connections from clients to the load balancer.
 *
 * @experimental
 */
export declare enum LoadBalancerListenerProtocol {
    /**
     * (experimental) HTTP protocol.
     *
     * @experimental
     */
    HTTP = "HTTP",
    /**
     * (experimental) HTTPS protocol.
     *
     * @experimental
     */
    HTTPS = "HTTPS",
    /**
     * (experimental) TCP protocol.
     *
     * @experimental
     */
    TCP = "TCP",
    /**
     * (experimental) TLS protocol.
     *
     * @experimental
     */
    TLS = "TLS",
    /**
     * (experimental) UDP protocol.
     *
     * @experimental
     */
    UDP = "UDP",
    /**
     * (experimental) TCP and UDP protocol.
     *
     * @experimental
     */
    TCP_UDP = "TCP_UDP"
}
/**
 * (experimental) Query input for looking up a load balancer listener.
 *
 * @experimental
 */
export interface LoadBalancerListenerContextQuery extends LoadBalancerFilter {
    /**
     * (experimental) Query account.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Query region.
     *
     * @experimental
     */
    readonly region: string;
    /**
     * (experimental) Find by listener's arn.
     *
     * @default - does not find by listener arn
     * @experimental
     */
    readonly listenerArn?: string;
    /**
     * (experimental) Filter by listener protocol.
     *
     * @default - does not filter by listener protocol
     * @experimental
     */
    readonly listenerProtocol?: LoadBalancerListenerProtocol;
    /**
     * (experimental) Filter listeners by listener port.
     *
     * @default - does not filter by a listener port
     * @experimental
     */
    readonly listenerPort?: number;
}
/**
 * (experimental) Query input for looking up a security group.
 *
 * @experimental
 */
export interface SecurityGroupContextQuery {
    /**
     * (experimental) Query account.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) Query region.
     *
     * @experimental
     */
    readonly region: string;
    /**
     * (experimental) Security group id.
     *
     * @experimental
     */
    readonly securityGroupId: string;
}
export declare type ContextQueryProperties = AmiContextQuery | AvailabilityZonesContextQuery | HostedZoneContextQuery | SSMParameterContextQuery | VpcContextQuery | EndpointServiceAvailabilityZonesContextQuery | LoadBalancerContextQuery | LoadBalancerListenerContextQuery | SecurityGroupContextQuery;
