import { AwsDestination } from './aws-destination';
/**
 * (experimental) A file asset.
 *
 * @experimental
 */
export interface DockerImageAsset {
    /**
     * (experimental) Source description for file assets.
     *
     * @experimental
     */
    readonly source: DockerImageSource;
    /**
     * (experimental) Destinations for this file asset.
     *
     * @experimental
     */
    readonly destinations: {
        [id: string]: DockerImageDestination;
    };
}
/**
 * (experimental) Properties for how to produce a Docker image from a source.
 *
 * @experimental
 */
export interface DockerImageSource {
    /**
     * (experimental) The directory containing the Docker image build instructions.
     *
     * This path is relative to the asset manifest location.
     *
     * @default - Exactly one of `directory` and `executable` is required
     * @experimental
     */
    readonly directory?: string;
    /**
     * (experimental) A command-line executable that returns the name of a local Docker image on stdout after being run.
     *
     * @default - Exactly one of `directory` and `executable` is required
     * @experimental
     */
    readonly executable?: string[];
    /**
     * (experimental) The name of the file with build instructions.
     *
     * Only allowed when `directory` is set.
     *
     * @default "Dockerfile"
     * @experimental
     */
    readonly dockerFile?: string;
    /**
     * (experimental) Target build stage in a Dockerfile with multiple build stages.
     *
     * Only allowed when `directory` is set.
     *
     * @default - The last stage in the Dockerfile
     * @experimental
     */
    readonly dockerBuildTarget?: string;
    /**
     * (experimental) Additional build arguments.
     *
     * Only allowed when `directory` is set.
     *
     * @default - No additional build arguments
     * @experimental
     */
    readonly dockerBuildArgs?: {
        [name: string]: string;
    };
}
/**
 * (experimental) Where to publish docker images.
 *
 * @experimental
 */
export interface DockerImageDestination extends AwsDestination {
    /**
     * (experimental) Name of the ECR repository to publish to.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) Tag of the image to publish.
     *
     * @experimental
     */
    readonly imageTag: string;
}
