"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkSpacesMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class WorkSpacesMetrics {
    static availableAverage(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'Available',
            dimensions,
            statistic: 'Average',
        };
    }
    static unhealthyAverage(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'Unhealthy',
            dimensions,
            statistic: 'Average',
        };
    }
    static sessionLaunchTimeAverage(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'SessionLaunchTime',
            dimensions,
            statistic: 'Average',
        };
    }
    static connectionSuccessSum(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'ConnectionSuccess',
            dimensions,
            statistic: 'Sum',
        };
    }
    static connectionFailureSum(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'ConnectionFailure',
            dimensions,
            statistic: 'Sum',
        };
    }
    static connectionAttemptSum(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'ConnectionAttempt',
            dimensions,
            statistic: 'Sum',
        };
    }
    static inSessionLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'InSessionLatency',
            dimensions,
            statistic: 'Average',
        };
    }
    static sessionDisconnectSum(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'SessionDisconnect',
            dimensions,
            statistic: 'Sum',
        };
    }
    static userConnectedSum(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'UserConnected',
            dimensions,
            statistic: 'Sum',
        };
    }
    static stoppedSum(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'Stopped',
            dimensions,
            statistic: 'Sum',
        };
    }
    static maintenanceSum(dimensions) {
        return {
            namespace: 'AWS/WorkSpaces',
            metricName: 'Maintenance',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.WorkSpacesMetrics = WorkSpacesMetrics;
//# sourceMappingURL=data:application/json;base64,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