import { Construct } from 'constructs';
import { Chain } from '../chain';
import { IChainable, INextable } from '../types';
import { State } from './state';
/**
 * (experimental) The result of a Pass operation.
 *
 * @experimental
 */
export declare class Result {
    readonly value: any;
    /**
     * (experimental) The result of the operation is a string.
     *
     * @experimental
     */
    static fromString(value: string): Result;
    /**
     * (experimental) The result of the operation is a number.
     *
     * @experimental
     */
    static fromNumber(value: number): Result;
    /**
     * (experimental) The result of the operation is a boolean.
     *
     * @experimental
     */
    static fromBoolean(value: boolean): Result;
    /**
     * (experimental) The result of the operation is an object.
     *
     * @experimental
     */
    static fromObject(value: {
        [key: string]: any;
    }): Result;
    /**
     * (experimental) The result of the operation is an array.
     *
     * @experimental
     */
    static fromArray(value: any[]): Result;
    /**
     * @param value result of the Pass operation.
     * @experimental
     */
    protected constructor(value: any);
}
/**
 * (experimental) Properties for defining a Pass state.
 *
 * @experimental
 */
export interface PassProps {
    /**
     * (experimental) An optional description for this state.
     *
     * @default No comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly inputPath?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly outputPath?: string;
    /**
     * (experimental) JSONPath expression to indicate where to inject the state's output.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     *
     * @default $
     * @experimental
     */
    readonly resultPath?: string;
    /**
     * (experimental) If given, treat as the result of this operation.
     *
     * Can be used to inject or replace the current execution state.
     *
     * @default No injected result
     * @experimental
     */
    readonly result?: Result;
    /**
     * (experimental) Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
     *
     * @default No parameters
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
     * @experimental
     */
    readonly parameters?: {
        [name: string]: any;
    };
}
/**
 * (experimental) Define a Pass in the state machine.
 *
 * A Pass state can be used to transform the current exeuction's state.
 *
 * @experimental
 */
export declare class Pass extends State implements INextable {
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    private readonly result?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: PassProps);
    /**
     * (experimental) Continue normal execution with the given state.
     *
     * @experimental
     */
    next(next: IChainable): Chain;
    /**
     * (experimental) Return the Amazon States Language object for this state.
     *
     * @experimental
     */
    toStateJson(): object;
    /**
     * Render Parameters in ASL JSON format
     */
    private renderParameters;
}
