import { Construct } from 'constructs';
import { Chain } from '../chain';
import { CatchProps, IChainable, INextable, RetryProps } from '../types';
import { State } from './state';
/**
 * (experimental) Properties for defining a Map state.
 *
 * @experimental
 */
export interface MapProps {
    /**
     * (experimental) An optional description for this state.
     *
     * @default No comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly inputPath?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly outputPath?: string;
    /**
     * (experimental) JSONPath expression to indicate where to inject the state's output.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     *
     * @default $
     * @experimental
     */
    readonly resultPath?: string;
    /**
     * (experimental) JSONPath expression to select the array to iterate over.
     *
     * @default $
     * @experimental
     */
    readonly itemsPath?: string;
    /**
     * (experimental) The JSON that you want to override your default iteration input.
     *
     * @default $
     * @experimental
     */
    readonly parameters?: {
        [key: string]: any;
    };
    /**
     * (experimental) The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
     *
     * You can use ResultSelector to create a payload with values that are static
     * or selected from the state's raw result.
     *
     * @default - None
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector
     * @experimental
     */
    readonly resultSelector?: {
        [key: string]: any;
    };
    /**
     * (experimental) MaxConcurrency.
     *
     * An upper bound on the number of iterations you want running at once.
     *
     * @default - full concurrency
     * @experimental
     */
    readonly maxConcurrency?: number;
}
/**
 * Returns true if the value passed is a positive integer
 * @param value the value ti validate
 */
export declare const isPositiveInteger: (value: number) => boolean;
/**
 * (experimental) Define a Map state in the state machine.
 *
 * A `Map` state can be used to run a set of steps for each element of an input array.
 * A Map state will execute the same steps for multiple entries of an array in the state input.
 *
 * While the Parallel state executes multiple branches of steps using the same input, a Map state
 * will execute the same steps for multiple entries of an array in the state input.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html
 * @experimental
 */
export declare class Map extends State implements INextable {
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    private readonly maxConcurrency;
    private readonly itemsPath?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: MapProps);
    /**
     * (experimental) Add retry configuration for this state.
     *
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     *
     * @experimental
     */
    addRetry(props?: RetryProps): Map;
    /**
     * (experimental) Add a recovery handler for this state.
     *
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     *
     * @experimental
     */
    addCatch(handler: IChainable, props?: CatchProps): Map;
    /**
     * (experimental) Continue normal execution with the given state.
     *
     * @experimental
     */
    next(next: IChainable): Chain;
    /**
     * (experimental) Define iterator state machine in Map.
     *
     * @experimental
     */
    iterator(iterator: IChainable): Map;
    /**
     * (experimental) Return the Amazon States Language object for this state.
     *
     * @experimental
     */
    toStateJson(): object;
    /**
     * (experimental) Validate this state.
     *
     * @experimental
     */
    protected validate(): string[];
    private renderItemsPath;
    /**
     * Render Parameters in ASL JSON format
     */
    private renderParameters;
}
