import { Construct } from 'constructs';
import { INextable } from '../types';
import { State } from './state';
/**
 * (experimental) Properties for defining a Fail state.
 *
 * @experimental
 */
export interface FailProps {
    /**
     * (experimental) An optional description for this state.
     *
     * @default No comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) Error code used to represent this failure.
     *
     * @default No error code
     * @experimental
     */
    readonly error?: string;
    /**
     * (experimental) A description for the cause of the failure.
     *
     * @default No description
     * @experimental
     */
    readonly cause?: string;
}
/**
 * (experimental) Define a Fail state in the state machine.
 *
 * Reaching a Fail state terminates the state execution in failure.
 *
 * @experimental
 */
export declare class Fail extends State {
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    private readonly error?;
    private readonly cause?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: FailProps);
    /**
     * (experimental) Return the Amazon States Language object for this state.
     *
     * @experimental
     */
    toStateJson(): object;
}
