import * as cloudwatch from "../../aws-cloudwatch";
import * as iam from "../../aws-iam";
import * as logs from "../../aws-logs";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IChainable } from './types';
/**
 * (experimental) Two types of state machines are available in AWS Step Functions: EXPRESS AND STANDARD.
 *
 * @default STANDARD
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html
 * @experimental
 */
export declare enum StateMachineType {
    /**
     * (experimental) Express Workflows are ideal for high-volume, event processing workloads.
     *
     * @experimental
     */
    EXPRESS = "EXPRESS",
    /**
     * (experimental) Standard Workflows are ideal for long-running, durable, and auditable workflows.
     *
     * @experimental
     */
    STANDARD = "STANDARD"
}
/**
 * (experimental) Defines which category of execution history events are logged.
 *
 * @default ERROR
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html
 * @experimental
 */
export declare enum LogLevel {
    /**
     * (experimental) No Logging.
     *
     * @experimental
     */
    OFF = "OFF",
    /**
     * (experimental) Log everything.
     *
     * @experimental
     */
    ALL = "ALL",
    /**
     * (experimental) Log all errors.
     *
     * @experimental
     */
    ERROR = "ERROR",
    /**
     * (experimental) Log fatal errors.
     *
     * @experimental
     */
    FATAL = "FATAL"
}
/**
 * (experimental) Defines what execution history events are logged and where they are logged.
 *
 * @experimental
 */
export interface LogOptions {
    /**
     * (experimental) The log group where the execution history events will be logged.
     *
     * @experimental
     */
    readonly destination: logs.ILogGroup;
    /**
     * (experimental) Determines whether execution data is included in your log.
     *
     * @default true
     * @experimental
     */
    readonly includeExecutionData?: boolean;
    /**
     * (experimental) Defines which category of execution history events are logged.
     *
     * @default ERROR
     * @experimental
     */
    readonly level?: LogLevel;
}
/**
 * (experimental) Properties for defining a State Machine.
 *
 * @experimental
 */
export interface StateMachineProps {
    /**
     * (experimental) A name for the state machine.
     *
     * @default A name is automatically generated
     * @experimental
     */
    readonly stateMachineName?: string;
    /**
     * (experimental) Definition for this state machine.
     *
     * @experimental
     */
    readonly definition: IChainable;
    /**
     * (experimental) The execution role for the state machine service.
     *
     * @default A role is automatically created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Maximum run time for this state machine.
     *
     * @default No timeout
     * @experimental
     */
    readonly timeout?: Duration;
    /**
     * (experimental) Type of the state machine.
     *
     * @default StateMachineType.STANDARD
     * @experimental
     */
    readonly stateMachineType?: StateMachineType;
    /**
     * (experimental) Defines what execution history events are logged and where they are logged.
     *
     * @default No logging
     * @experimental
     */
    readonly logs?: LogOptions;
    /**
     * (experimental) Specifies whether Amazon X-Ray tracing is enabled for this state machine.
     *
     * @default false
     * @experimental
     */
    readonly tracingEnabled?: boolean;
}
/**
 * A new or imported state machine.
 */
declare abstract class StateMachineBase extends Resource implements IStateMachine {
    /**
     * (experimental) Import a state machine.
     *
     * @experimental
     */
    static fromStateMachineArn(scope: Construct, id: string, stateMachineArn: string): IStateMachine;
    abstract readonly stateMachineArn: string;
    /**
     * The principal this state machine is running as
     */
    abstract readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) Grant the given identity permissions to start an execution of this state machine.
     *
     * @experimental
     */
    grantStartExecution(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to read results from state machine.
     *
     * @experimental
     */
    grantRead(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity task response permissions on a state machine.
     *
     * @experimental
     */
    grantTaskResponse(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions on all executions of the state machine.
     *
     * @experimental
     */
    grantExecution(identity: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant the given identity custom permissions.
     *
     * @experimental
     */
    grant(identity: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Return the given named metric for this State Machine's executions.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that failed.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that were throttled.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricThrottled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that were aborted.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricAborted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that succeeded.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricSucceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that timed out.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricTimedOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that were started.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricStarted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the interval, in milliseconds, between the time the execution starts and the time it closes.
     *
     * @default - average over 5 minutes
     * @experimental
     */
    metricTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Returns the pattern for the execution ARN's of the state machine
     */
    private executionArn;
    private cannedMetric;
}
/**
 * (experimental) Define a StepFunctions State Machine.
 *
 * @experimental
 */
export declare class StateMachine extends StateMachineBase {
    /**
     * (experimental) Execution role of this state machine.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) The name of the state machine.
     *
     * @experimental
     * @attribute true
     */
    readonly stateMachineName: string;
    /**
     * (experimental) The ARN of the state machine.
     *
     * @experimental
     */
    readonly stateMachineArn: string;
    /**
     * (experimental) Type of the state machine.
     *
     * @experimental
     * @attribute true
     */
    readonly stateMachineType: StateMachineType;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StateMachineProps);
    /**
     * (experimental) The principal this state machine is running as.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * (experimental) Add the given statement to the role's policy.
     *
     * @experimental
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    private validateStateMachineName;
    private buildLoggingConfiguration;
    private buildTracingConfiguration;
}
/**
 * (experimental) A State Machine.
 *
 * @experimental
 */
export interface IStateMachine extends IResource, iam.IGrantable {
    /**
     * (experimental) The ARN of the state machine.
     *
     * @experimental
     * @attribute true
     */
    readonly stateMachineArn: string;
    /**
     * (experimental) Grant the given identity permissions to start an execution of this state machine.
     *
     * @param identity The principal.
     * @experimental
     */
    grantStartExecution(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity read permissions for this state machine.
     *
     * @param identity The principal.
     * @experimental
     */
    grantRead(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity read permissions for this state machine.
     *
     * @param identity The principal.
     * @experimental
     */
    grantTaskResponse(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions for all executions of a state machine.
     *
     * @param identity The principal.
     * @param actions The list of desired actions.
     * @experimental
     */
    grantExecution(identity: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant the given identity custom permissions.
     *
     * @param identity The principal.
     * @param actions The list of desired actions.
     * @experimental
     */
    grant(identity: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Return the given named metric for this State Machine's executions.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that failed.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that were throttled.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricThrottled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that were aborted.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricAborted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that succeeded.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricSucceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that timed out.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricTimedOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of executions that were started.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricStarted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the interval, in milliseconds, between the time the execution starts and the time it closes.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
export {};
