/**
 * (experimental) Extract a field from the State Machine data or context that gets passed around between states.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-paths.html
 * @experimental
 */
export declare class JsonPath {
    /**
     * (experimental) Special string value to discard state input, output or result.
     *
     * @experimental
     */
    static readonly DISCARD = "DISCARD";
    /**
     * (experimental) Instead of using a literal string, get the value from a JSON path.
     *
     * @experimental
     */
    static stringAt(path: string): string;
    /**
     * (experimental) Instead of using a literal string list, get the value from a JSON path.
     *
     * @experimental
     */
    static listAt(path: string): string[];
    /**
     * (experimental) Instead of using a literal number, get the value from a JSON path.
     *
     * @experimental
     */
    static numberAt(path: string): number;
    /**
     * (experimental) Use the entire data structure.
     *
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     *
     * @experimental
     */
    static get entirePayload(): string;
    /**
     * (experimental) Determines if the indicated string is an encoded JSON path.
     *
     * @param value string to be evaluated.
     * @experimental
     */
    static isEncodedJsonPath(value: string): boolean;
    /**
     * (experimental) Return the Task Token field.
     *
     * External actions will need this token to report step completion
     * back to StepFunctions using the `SendTaskSuccess` or `SendTaskFailure`
     * calls.
     *
     * @experimental
     */
    static get taskToken(): string;
    /**
     * (experimental) Use the entire context data structure.
     *
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     *
     * @experimental
     */
    static get entireContext(): string;
    private constructor();
}
/**
 * (deprecated) Extract a field from the State Machine data that gets passed around between states.
 *
 * @deprecated replaced by `JsonPath`
 */
export declare class Data {
    /**
     * (deprecated) Instead of using a literal string, get the value from a JSON path.
     *
     * @deprecated
     */
    static stringAt(path: string): string;
    /**
     * (deprecated) Instead of using a literal string list, get the value from a JSON path.
     *
     * @deprecated
     */
    static listAt(path: string): string[];
    /**
     * (deprecated) Instead of using a literal number, get the value from a JSON path.
     *
     * @deprecated
     */
    static numberAt(path: string): number;
    /**
     * (deprecated) Use the entire data structure.
     *
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     *
     * @deprecated
     */
    static get entirePayload(): string;
    /**
     * (deprecated) Determines if the indicated string is an encoded JSON path.
     *
     * @param value string to be evaluated.
     * @deprecated
     */
    static isJsonPathString(value: string): boolean;
    private constructor();
}
/**
 * (deprecated) Extract a field from the State Machine Context data.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#wait-token-contextobject
 * @deprecated replaced by `JsonPath`
 */
export declare class Context {
    /**
     * (deprecated) Instead of using a literal string, get the value from a JSON path.
     *
     * @deprecated
     */
    static stringAt(path: string): string;
    /**
     * (deprecated) Instead of using a literal number, get the value from a JSON path.
     *
     * @deprecated
     */
    static numberAt(path: string): number;
    /**
     * (deprecated) Return the Task Token field.
     *
     * External actions will need this token to report step completion
     * back to StepFunctions using the `SendTaskSuccess` or `SendTaskFailure`
     * calls.
     *
     * @deprecated
     */
    static get taskToken(): string;
    /**
     * (deprecated) Use the entire context data structure.
     *
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     *
     * @deprecated
     */
    static get entireContext(): string;
    private constructor();
}
/**
 * (experimental) Helper functions to work with structures containing fields.
 *
 * @experimental
 */
export declare class FieldUtils {
    /**
     * (experimental) Render a JSON structure containing fields to the right StepFunctions structure.
     *
     * @experimental
     */
    static renderObject(obj?: {
        [key: string]: any;
    }): {
        [key: string]: any;
    } | undefined;
    /**
     * (experimental) Return all JSON paths used in the given structure.
     *
     * @experimental
     */
    static findReferencedPaths(obj?: {
        [key: string]: any;
    }): string[];
    /**
     * (experimental) Returns whether the given task structure contains the TaskToken field anywhere.
     *
     * The field is considered included if the field itself or one of its containing
     * fields occurs anywhere in the payload.
     *
     * @experimental
     */
    static containsTaskToken(obj?: {
        [key: string]: any;
    }): boolean;
    private constructor();
}
