import { Parallel, ParallelProps } from './states/parallel';
import { State } from './states/state';
import { IChainable, INextable } from './types';
/**
 * (experimental) A collection of states to chain onto.
 *
 * A Chain has a start and zero or more chainable ends. If there are
 * zero ends, calling next() on the Chain will fail.
 *
 * @experimental
 */
export declare class Chain implements IChainable {
    private readonly lastAdded;
    /**
     * (experimental) Begin a new Chain from one chainable.
     *
     * @experimental
     */
    static start(state: IChainable): Chain;
    /**
     * (experimental) Make a Chain with the start from one chain and the ends from another.
     *
     * @experimental
     */
    static sequence(start: IChainable, next: IChainable): Chain;
    /**
     * (experimental) Make a Chain with specific start and end states, and a last-added Chainable.
     *
     * @experimental
     */
    static custom(startState: State, endStates: INextable[], lastAdded: IChainable): Chain;
    /**
     * (experimental) Identify this Chain.
     *
     * @experimental
     */
    readonly id: string;
    /**
     * (experimental) The start state of this chain.
     *
     * @experimental
     */
    readonly startState: State;
    /**
     * (experimental) The chainable end state(s) of this chain.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    private constructor();
    /**
     * (experimental) Continue normal execution with the given state.
     *
     * @experimental
     */
    next(next: IChainable): Chain;
    /**
     * (experimental) Return a single state that encompasses all states in the chain.
     *
     * This can be used to add error handling to a sequence of states.
     *
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     *
     * @experimental
     */
    toSingleState(id: string, props?: ParallelProps): Parallel;
}
