import * as cloudwatch from "../../aws-cloudwatch";
import * as iam from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for defining a new Step Functions Activity.
 *
 * @experimental
 */
export interface ActivityProps {
    /**
     * (experimental) The name for this activity.
     *
     * @default - If not supplied, a name is generated
     * @experimental
     */
    readonly activityName?: string;
}
/**
 * (experimental) Define a new Step Functions Activity.
 *
 * @experimental
 */
export declare class Activity extends Resource implements IActivity {
    /**
     * (experimental) Construct an Activity from an existing Activity ARN.
     *
     * @experimental
     */
    static fromActivityArn(scope: Construct, id: string, activityArn: string): IActivity;
    /**
     * (experimental) Construct an Activity from an existing Activity Name.
     *
     * @experimental
     */
    static fromActivityName(scope: Construct, id: string, activityName: string): IActivity;
    /**
     * (experimental) The ARN of the activity.
     *
     * @experimental
     * @attribute true
     */
    readonly activityArn: string;
    /**
     * (experimental) The name of the activity.
     *
     * @experimental
     * @attribute true
     */
    readonly activityName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ActivityProps);
    /**
     * (experimental) Grant the given identity permissions on this Activity.
     *
     * @param identity The principal.
     * @param actions The list of desired actions.
     * @experimental
     */
    grant(identity: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Return the given named metric for this Activity.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The interval, in milliseconds, between the time the activity starts and the time it closes.
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricRunTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The interval, in milliseconds, for which the activity stays in the schedule state.
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricScheduleTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity is scheduled.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricScheduled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity times out.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricTimedOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity is started.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricStarted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity succeeds.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricSucceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity fails.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times the heartbeat times out for this activity.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricHeartbeatTimedOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private generateName;
    private cannedMetric;
}
/**
 * (experimental) Represents a Step Functions Activity https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html.
 *
 * @experimental
 */
export interface IActivity extends IResource {
    /**
     * (experimental) The ARN of the activity.
     *
     * @experimental
     * @attribute true
     */
    readonly activityArn: string;
    /**
     * (experimental) The name of the activity.
     *
     * @experimental
     * @attribute true
     */
    readonly activityName: string;
}
