import * as iam from "../../../aws-iam";
import * as sns from "../../../aws-sns";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for publishing a message to an SNS topic.
 *
 * @experimental
 */
export interface SnsPublishProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The SNS topic that the task will publish to.
     *
     * @experimental
     */
    readonly topic: sns.ITopic;
    /**
     * (experimental) The message you want to send.
     *
     * With the exception of SMS, messages must be UTF-8 encoded strings and
     * at most 256 KB in size.
     * For SMS, each message can contain up to 140 characters.
     *
     * @experimental
     */
    readonly message: sfn.TaskInput;
    /**
     * (experimental) Send different messages for each transport protocol.
     *
     * For example, you might want to send a shorter message to SMS subscribers
     * and a more verbose message to email and SQS subscribers.
     *
     * Your message must be a JSON object with a top-level JSON key of
     * "default" with a value that is a string
     * You can define other top-level keys that define the message you want to
     * send to a specific transport protocol (i.e. "sqs", "email", "http", etc)
     *
     * @default false
     * @see https://docs.aws.amazon.com/sns/latest/api/API_Publish.html#API_Publish_RequestParameters
     * @experimental
     */
    readonly messagePerSubscriptionType?: boolean;
    /**
     * (experimental) Used as the "Subject" line when the message is delivered to email endpoints.
     *
     * This field will also be included, if present, in the standard JSON messages
     * delivered to other endpoints.
     *
     * @default - No subject
     * @experimental
     */
    readonly subject?: string;
}
/**
 * (experimental) A Step Functions Task to publish messages to SNS topic.
 *
 * @experimental
 */
export declare class SnsPublish extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics: sfn.TaskMetricsConfig | undefined;
    /**
     * @experimental
     */
    protected readonly taskPolicies: iam.PolicyStatement[] | undefined;
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SnsPublishProps);
    /**
     * Provides the SNS Publish service integration task configuration
     */
    /**
     * @internal
     */
    protected _renderTask(): any;
}
