"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const sfn = require("../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
/**
 * (experimental) A Step Functions Task to evaluate an expression.
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
class EvaluateExpression extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        this.evalFn = createEvalFn((_b = this.props.runtime) !== null && _b !== void 0 ? _b : lambda.Runtime.NODEJS_14_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [this.evalFn.functionArn],
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9-_]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m),
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
_a = JSII_RTTI_SYMBOL_1;
EvaluateExpression[_a] = { fqn: "monocdk.aws_stepfunctions_tasks.EvaluateExpression", version: "1.106.1" };
function createEvalFn(runtime, scope) {
    const lambdaPurpose = 'Eval';
    const nodeJsGuids = {
        [lambda.Runtime.NODEJS_14_X.name]: 'da2d1181-604e-4a45-8694-1a6abd7fe42d',
        [lambda.Runtime.NODEJS_12_X.name]: '2b81e383-aad2-44db-8aaf-b4809ae0e3b4',
        [lambda.Runtime.NODEJS_10_X.name]: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
    };
    switch (runtime) {
        case lambda.Runtime.NODEJS_14_X:
        case lambda.Runtime.NODEJS_12_X:
        case lambda.Runtime.NODEJS_10_X:
            const uuid = nodeJsGuids[runtime.name];
            if (uuid) {
                return new lambda.SingletonFunction(scope, 'EvalFunction', {
                    runtime,
                    uuid,
                    handler: 'index.handler',
                    lambdaPurpose,
                    code: lambda.Code.fromAsset(path.join(__dirname, 'eval-nodejs-handler')),
                });
            }
            break;
    }
    throw new Error(`The runtime ${runtime.name} is currently not supported.`);
}
//# sourceMappingURL=data:application/json;base64,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