import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for EmrTerminateCluster.
 *
 * @experimental
 */
export interface EmrTerminateClusterProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The ClusterId to terminate.
     *
     * @experimental
     */
    readonly clusterId: string;
}
/**
 * (experimental) A Step Functions Task to terminate an EMR Cluster.
 *
 * @experimental
 */
export declare class EmrTerminateCluster extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EmrTerminateClusterProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    /**
     * This generates the PolicyStatements required by the Task to call TerminateCluster.
     */
    private createPolicyStatements;
}
