import * as ec2 from "../../../aws-ec2";
import * as ecs from "../../../aws-ecs";
import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
import { ContainerOverride } from '..';
/**
 * (experimental) Properties for ECS Tasks.
 *
 * @experimental
 */
export interface EcsRunTaskProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The ECS cluster to run the task on.
     *
     * @experimental
     */
    readonly cluster: ecs.ICluster;
    /**
     * (experimental) [disable-awslint:ref-via-interface] Task Definition used for running tasks in the service.
     *
     * Note: this must be TaskDefinition, and not ITaskDefinition,
     * as it requires properties that are not known for imported task definitions
     *
     * @experimental
     */
    readonly taskDefinition: ecs.TaskDefinition;
    /**
     * (experimental) Container setting overrides.
     *
     * Specify the container to use and the overrides to apply.
     *
     * @default - No overrides
     * @experimental
     */
    readonly containerOverrides?: ContainerOverride[];
    /**
     * (experimental) Subnets to place the task's ENIs.
     *
     * @default - Public subnets if assignPublicIp is set. Private subnets otherwise.
     * @experimental
     */
    readonly subnets?: ec2.SubnetSelection;
    /**
     * (experimental) Existing security groups to use for the tasks.
     *
     * @default - A new security group is created
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) Assign public IP addresses to each task.
     *
     * @default false
     * @experimental
     */
    readonly assignPublicIp?: boolean;
    /**
     * (experimental) An Amazon ECS launch type determines the type of infrastructure on which your tasks and services are hosted.
     *
     * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html
     * @experimental
     */
    readonly launchTarget: IEcsLaunchTarget;
}
/**
 * (experimental) An Amazon ECS launch type determines the type of infrastructure on which your tasks and services are hosted.
 *
 * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html
 * @experimental
 */
export interface IEcsLaunchTarget {
    /**
     * (experimental) called when the ECS launch target is configured on RunTask.
     *
     * @experimental
     */
    bind(task: EcsRunTask, launchTargetOptions: LaunchTargetBindOptions): EcsLaunchTargetConfig;
}
/**
 * (experimental) Options for binding a launch target to an ECS run job task.
 *
 * @experimental
 */
export interface LaunchTargetBindOptions {
    /**
     * (experimental) Task definition to run Docker containers in Amazon ECS.
     *
     * @experimental
     */
    readonly taskDefinition: ecs.ITaskDefinition;
    /**
     * (experimental) A regional grouping of one or more container instances on which you can run tasks and services.
     *
     * @default - No cluster
     * @experimental
     */
    readonly cluster?: ecs.ICluster;
}
/**
 * (experimental) Configuration options for the ECS launch type.
 *
 * @experimental
 */
export interface EcsLaunchTargetConfig {
    /**
     * (experimental) Additional parameters to pass to the base task.
     *
     * @default - No additional parameters passed
     * @experimental
     */
    readonly parameters?: {
        [key: string]: any;
    };
}
/**
 * (experimental) Properties to define an ECS service.
 *
 * @experimental
 */
export interface EcsFargateLaunchTargetOptions {
    /**
     * (experimental) Refers to a specific runtime environment for Fargate task infrastructure.
     *
     * Fargate platform version is a combination of the kernel and container runtime versions.
     *
     * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html
     * @experimental
     */
    readonly platformVersion: ecs.FargatePlatformVersion;
}
/**
 * (experimental) Options to run an ECS task on EC2 in StepFunctions and ECS.
 *
 * @experimental
 */
export interface EcsEc2LaunchTargetOptions {
    /**
     * (experimental) Placement constraints.
     *
     * @default - None
     * @experimental
     */
    readonly placementConstraints?: ecs.PlacementConstraint[];
    /**
     * (experimental) Placement strategies.
     *
     * @default - None
     * @experimental
     */
    readonly placementStrategies?: ecs.PlacementStrategy[];
}
/**
 * (experimental) Configuration for running an ECS task on Fargate.
 *
 * @see https://docs.aws.amazon.com/AmazonECS/latest/userguide/launch_types.html#launch-type-fargate
 * @experimental
 */
export declare class EcsFargateLaunchTarget implements IEcsLaunchTarget {
    private readonly options?;
    /**
     * @experimental
     */
    constructor(options?: EcsFargateLaunchTargetOptions | undefined);
    /**
     * (experimental) Called when the Fargate launch type configured on RunTask.
     *
     * @experimental
     */
    bind(_task: EcsRunTask, launchTargetOptions: LaunchTargetBindOptions): EcsLaunchTargetConfig;
}
/**
 * (experimental) Configuration for running an ECS task on EC2.
 *
 * @see https://docs.aws.amazon.com/AmazonECS/latest/userguide/launch_types.html#launch-type-ec2
 * @experimental
 */
export declare class EcsEc2LaunchTarget implements IEcsLaunchTarget {
    private readonly options?;
    /**
     * @experimental
     */
    constructor(options?: EcsEc2LaunchTargetOptions | undefined);
    /**
     * (experimental) Called when the EC2 launch type is configured on RunTask.
     *
     * @experimental
     */
    bind(_task: EcsRunTask, launchTargetOptions: LaunchTargetBindOptions): EcsLaunchTargetConfig;
}
/**
 * (experimental) Run a Task on ECS or Fargate.
 *
 * @experimental
 */
export declare class EcsRunTask extends sfn.TaskStateBase implements ec2.IConnectable {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * (experimental) Manage allowed network traffic for this service.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private securityGroups;
    private networkConfiguration?;
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EcsRunTaskProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    private configureAwsVpcNetworking;
    private validateNoNetworkingProps;
    private makePolicyStatements;
    /**
     * Returns the ARN of the task definition family by removing the
     * revision from the task definition ARN
     * Before - arn:aws:ecs:us-west-2:123456789012:task-definition/hello_world:8
     * After - arn:aws:ecs:us-west-2:123456789012:task-definition/hello_world
     */
    private getTaskDefinitionFamilyArn;
    private taskExecutionRoles;
}
